/*
 * Decompiled with CFR 0.152.
 */
package unluac.util;

public class StringUtils {
    public static String toPrintString(String string) {
        return StringUtils.toPrintString(string, -1);
    }

    public static String toPrintString(String string, int n) {
        if (string == null) {
            return "null";
        }
        if (n < 0) {
            n = string.length();
        }
        n = Math.min(n, string.length());
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('\"');
        for (int i = 0; i < n; ++i) {
            char c;
            char c2 = c = string.charAt(i);
            if (c == '\"') {
                stringBuilder.append("\\\"");
                continue;
            }
            if (c == '\\') {
                stringBuilder.append("\\\\");
                continue;
            }
            if (c2 >= ' ' && c2 <= '~') {
                stringBuilder.append(c);
                continue;
            }
            if (c == '\n') {
                stringBuilder.append("\\n");
                continue;
            }
            if (c == '\t') {
                stringBuilder.append("\\t");
                continue;
            }
            if (c == '\r') {
                stringBuilder.append("\\r");
                continue;
            }
            if (c == '\b') {
                stringBuilder.append("\\b");
                continue;
            }
            if (c == '\f') {
                stringBuilder.append("\\f");
                continue;
            }
            if (c2 == '\u000b') {
                stringBuilder.append("\\v");
                continue;
            }
            if (c2 == '\u0007') {
                stringBuilder.append("\\a");
                continue;
            }
            stringBuilder.append(String.format("\\x%02x", c2));
        }
        stringBuilder.append('\"');
        return stringBuilder.toString();
    }

    public static String fromPrintString(String string) {
        if (string.equals("null")) {
            return null;
        }
        if (string.charAt(0) != '\"') {
            throw new IllegalStateException("Bad string " + string);
        }
        if (string.charAt(string.length() - 1) != '\"') {
            throw new IllegalStateException("Bad string " + string);
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n = 1;
        while (n < string.length() - 1) {
            char c;
            if ((c = string.charAt(n++)) == '\\') {
                if (n < string.length() - 1) {
                    if ((c = string.charAt(n++)) == '\"') {
                        stringBuilder.append('\"');
                        continue;
                    }
                    if (c == '\\') {
                        stringBuilder.append('\\');
                        continue;
                    }
                    if (c == 'n') {
                        stringBuilder.append('\n');
                        continue;
                    }
                    if (c == 't') {
                        stringBuilder.append('\t');
                        continue;
                    }
                    if (c == 'r') {
                        stringBuilder.append('\r');
                        continue;
                    }
                    if (c == 'b') {
                        stringBuilder.append('\b');
                        continue;
                    }
                    if (c == 'f') {
                        stringBuilder.append('\f');
                        continue;
                    }
                    if (c == 'v') {
                        stringBuilder.append('\u000b');
                        continue;
                    }
                    if (c == 'a') {
                        stringBuilder.append('\u0007');
                        continue;
                    }
                    if (c == 'x') {
                        if (n + 1 < string.length() - 1) {
                            String string2 = string.substring(n, n + 2);
                            n += 2;
                            stringBuilder.append((char)Integer.parseInt(string2, 16));
                            continue;
                        }
                        return null;
                    }
                    return null;
                }
                return null;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    private StringUtils() {
    }
}

