/*
 * Decompiled with CFR 0.152.
 */
package unluac.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;

public class FileUtils {
    public static InputStream createSmartTextFileReader(File file) throws IOException {
        int n;
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        byte[] byArray = new byte[2];
        int n2 = 0;
        bufferedInputStream.mark(byArray.length);
        while ((n = bufferedInputStream.read(byArray, n2, byArray.length - n2)) != -1 && (n2 += n) < byArray.length) {
        }
        if (byArray.length >= 2 && byArray[0] == -1 && byArray[1] == -2) {
            return FileUtils.readerToUTF8Stream(new InputStreamReader((InputStream)bufferedInputStream, "UTF-16LE"));
        }
        if (byArray.length >= 2 && byArray[0] == -2 && byArray[1] == -1) {
            return FileUtils.readerToUTF8Stream(new InputStreamReader((InputStream)bufferedInputStream, "UTF-16BE"));
        }
        bufferedInputStream.reset();
        return bufferedInputStream;
    }

    public static InputStream readerToUTF8Stream(final Reader reader) {
        final CharsetEncoder charsetEncoder = Charset.forName("UTF-8").newEncoder();
        final CharBuffer charBuffer = CharBuffer.allocate(2);
        final ByteBuffer byteBuffer = ByteBuffer.allocate(8);
        byteBuffer.limit(0);
        return new InputStream(){

            @Override
            public int read() throws IOException {
                if (byteBuffer.position() < byteBuffer.limit()) {
                    return 0xFF & byteBuffer.get();
                }
                int n = reader.read();
                if (n <= 127) {
                    return n;
                }
                char c = (char)n;
                charBuffer.position(0);
                charBuffer.limit(1);
                charBuffer.put(c);
                if (Character.isSurrogate(c) && (n = reader.read()) >= 0) {
                    charBuffer.limit(2);
                    charBuffer.put((char)n);
                }
                charBuffer.position(0);
                byteBuffer.limit(byteBuffer.capacity());
                byteBuffer.position(0);
                charsetEncoder.reset();
                CoderResult coderResult = charsetEncoder.encode(charBuffer, byteBuffer, true);
                if (coderResult.isError() || coderResult.isOverflow()) {
                    throw new IllegalStateException(coderResult.toString());
                }
                byteBuffer.limit(byteBuffer.position());
                byteBuffer.position(0);
                return this.read();
            }
        };
    }

    private FileUtils() {
    }
}

