/*
 * Decompiled with CFR 0.152.
 */
package unluac.test;

import java.io.File;
import java.io.IOException;
import unluac.Configuration;
import unluac.Main;
import unluac.assemble.AssemblerException;
import unluac.test.Compare;
import unluac.test.LuaC;
import unluac.test.LuaSpec;
import unluac.test.TestFile;
import unluac.test.TestReport;
import unluac.test.TestResult;
import unluac.test.UnluacSpec;

public class TestSuite {
    private static String working_dir = "./test/working/";
    private static String compiled = "luac.out";
    private static String decompiled = "unluac.out";
    private static String recompiled = "test.out";
    private String name;
    private String path;
    private TestFile[] files;
    private String ext = ".lua";

    public TestSuite(String string, String string2, TestFile[] testFileArray) {
        this.name = string;
        this.path = string2;
        this.files = testFileArray;
    }

    public String testName(LuaSpec luaSpec, String string) {
        if (this.name == null) {
            return luaSpec.id() + ": " + string;
        }
        return luaSpec.id() + ": " + this.name + "/" + string.replace('\\', '/');
    }

    private TestResult test(LuaSpec luaSpec, UnluacSpec unluacSpec, String string, Configuration configuration) {
        try {
            LuaC.compile(luaSpec, string, working_dir + compiled);
        }
        catch (IOException iOException) {
            return TestResult.SKIPPED;
        }
        try {
            unluacSpec.run(working_dir + compiled, working_dir + decompiled, configuration);
            if (!unluacSpec.disassemble) {
                LuaC.compile(luaSpec, working_dir + decompiled, working_dir + recompiled);
            } else {
                Main.assemble(working_dir + decompiled, working_dir + recompiled);
            }
            Compare compare = !unluacSpec.disassemble ? new Compare(Compare.Mode.NORMAL) : new Compare(Compare.Mode.FULL);
            return compare.bytecode_equal(working_dir + compiled, working_dir + recompiled) ? TestResult.OK : TestResult.FAILED;
        }
        catch (IOException iOException) {
            return TestResult.FAILED;
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
            return TestResult.FAILED;
        }
        catch (AssemblerException assemblerException) {
            assemblerException.printStackTrace();
            return TestResult.FAILED;
        }
    }

    private TestResult testc(LuaSpec luaSpec, UnluacSpec unluacSpec, String string, Configuration configuration) {
        try {
            unluacSpec.run(string, working_dir + decompiled, configuration);
            LuaC.compile(luaSpec, working_dir + decompiled, working_dir + recompiled);
            Compare compare = new Compare(Compare.Mode.NORMAL);
            return compare.bytecode_equal(string, working_dir + recompiled) ? TestResult.OK : TestResult.FAILED;
        }
        catch (IOException iOException) {
            return TestResult.FAILED;
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
            return TestResult.FAILED;
        }
    }

    public boolean run(LuaSpec luaSpec, UnluacSpec unluacSpec, TestReport testReport, Configuration configuration) throws IOException {
        int n = 0;
        File file = new File(working_dir);
        if (!file.exists()) {
            file.mkdir();
        }
        block4: for (TestFile testFile : this.files) {
            if (!luaSpec.compatible(testFile)) continue;
            String string = testFile.name;
            Configuration configuration2 = this.configure(testFile, configuration);
            TestResult testResult = this.test(luaSpec, unluacSpec, this.path + string + this.ext, configuration2);
            testReport.result(this.testName(luaSpec, string), testResult);
            switch (testResult) {
                case OK: {
                    System.out.print(".");
                    continue block4;
                }
                case SKIPPED: {
                    System.out.print(",");
                    continue block4;
                }
                default: {
                    System.out.print("!");
                    ++n;
                }
            }
        }
        return n == 0;
    }

    public boolean run(LuaSpec luaSpec, UnluacSpec unluacSpec, String string, boolean bl, Configuration configuration) throws IOException {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        File file = new File(working_dir);
        if (!file.exists()) {
            file.mkdir();
        }
        String string2 = string;
        Object object = !string.contains("/") ? this.path + string2 + this.ext : string2;
        TestResult testResult = !bl ? this.test(luaSpec, unluacSpec, (String)object, configuration) : this.testc(luaSpec, unluacSpec, (String)object, configuration);
        switch (testResult) {
            case OK: {
                System.out.println("Passed: " + string2);
                ++n;
                break;
            }
            case SKIPPED: {
                System.out.println("Skipped: " + string2);
                ++n2;
                break;
            }
            default: {
                System.out.println("Failed: " + string2);
                ++n3;
            }
        }
        if (n3 == 0 && n2 == 0) {
            System.out.println(luaSpec.getLuaCName() + ": All tests passed!");
        } else {
            System.out.println(luaSpec.getLuaCName() + ": Failed " + n3 + " of " + (n3 + n) + " tests, skipped " + n2 + " tests.");
        }
        return n3 == 0;
    }

    private Configuration configure(TestFile testFile, Configuration configuration) {
        Configuration configuration2 = null;
        if (testFile.getFlag(1) && configuration.strict_scope) {
            configuration2 = this.extend(configuration, configuration2);
            configuration2.strict_scope = false;
        }
        return configuration2 != null ? configuration2 : configuration;
    }

    private Configuration extend(Configuration configuration, Configuration configuration2) {
        return configuration2 != null ? configuration2 : new Configuration(configuration);
    }
}

