/*
 * Decompiled with CFR 0.152.
 */
package unluac.test;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import unluac.test.TestResult;

public class TestReport {
    private int passed = 0;
    private int failed = 0;
    private int skipped = 0;
    private List<String> failedTests = new ArrayList<String>();
    private List<String> skippedTests = new ArrayList<String>();

    public void report(PrintStream printStream) {
        if (this.failed == 0 && this.skipped == 0) {
            printStream.println("All tests passed!");
        } else {
            for (String string : this.failedTests) {
                printStream.println("Failed: " + string);
            }
            for (String string : this.skippedTests) {
                printStream.println("Skipped: " + string);
            }
            printStream.println("Failed " + this.failed + " of " + (this.failed + this.passed) + " tests, skipped " + this.skipped + " tests.");
        }
    }

    public void result(String string, TestResult testResult) {
        switch (testResult) {
            case OK: {
                ++this.passed;
                break;
            }
            case FAILED: {
                this.failedTests.add(string);
                ++this.failed;
                break;
            }
            case SKIPPED: {
                this.skippedTests.add(string);
                ++this.skipped;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }
}

