/*
 * Decompiled with CFR 0.152.
 */
package unluac.test;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import unluac.Configuration;
import unluac.test.LuaSpec;
import unluac.test.TestFile;
import unluac.test.TestReport;
import unluac.test.TestSuite;
import unluac.test.UnluacSpec;

public class RunExtendedTests {
    private static void gatherTests(Path path, Path path2, List<TestFile> list) throws IOException {
        for (Path path3 : Files.newDirectoryStream(path2, "*.lua")) {
            String string = path.relativize(path3).toString();
            list.add(new TestFile(string.substring(0, string.length() - 4)));
        }
        for (Path path3 : Files.newDirectoryStream(path2)) {
            if (!Files.isDirectory(path3, new LinkOption[0])) continue;
            RunExtendedTests.gatherTests(path, path3, list);
        }
    }

    public static void main(String[] stringArray) throws IOException {
        FileSystem fileSystem = FileSystems.getDefault();
        Path path = fileSystem.getPath(stringArray[0], new String[0]);
        TestReport testReport = new TestReport();
        Configuration configuration = new Configuration();
        for (int i = 80; i <= 84; ++i) {
            LuaSpec luaSpec = new LuaSpec(i);
            UnluacSpec unluacSpec = new UnluacSpec();
            System.out.println(luaSpec.id());
            for (Path path2 : Files.newDirectoryStream(path)) {
                if (!Files.isDirectory(path2, new LinkOption[0]) || !luaSpec.compatible(path2.getFileName().toString())) continue;
                ArrayList<TestFile> arrayList = new ArrayList<TestFile>();
                RunExtendedTests.gatherTests(path2, path2, arrayList);
                TestSuite testSuite = new TestSuite(path2.getFileName().toString(), path2.toString() + File.separator, arrayList.toArray(new TestFile[arrayList.size()]));
                System.out.print("\t" + path2.getFileName().toString());
                testSuite.run(luaSpec, unluacSpec, testReport, configuration);
                System.out.println();
            }
        }
        testReport.report(System.out);
    }
}

