/*
 * Decompiled with CFR 0.152.
 */
package unluac.test;

import unluac.test.TestFile;

public class LuaSpec {
    private boolean isDefault;
    private int version;
    private int minorVersion;
    private NumberFormat numberFormat;
    private boolean strip;

    public LuaSpec() {
        this.isDefault = true;
        this.version = 0;
        this.numberFormat = NumberFormat.DEFAULT;
        this.strip = false;
    }

    public LuaSpec(int n) {
        this(n, -1);
    }

    public LuaSpec(int n, int n2) {
        this.isDefault = false;
        this.version = n;
        this.minorVersion = n2;
        this.numberFormat = NumberFormat.DEFAULT;
        this.strip = false;
    }

    public String id() {
        Object object = "lua";
        object = (String)object + Integer.toHexString(this.version);
        object = (String)object + this.getMinorVersionString();
        return object;
    }

    public void setNumberFormat(NumberFormat numberFormat) {
        this.numberFormat = numberFormat;
    }

    public void setStrip(boolean bl) {
        this.strip = bl;
    }

    public String getLuaCName() {
        return "luac" + this.getVersionString() + this.getMinorVersionString() + this.getNumberFormatString();
    }

    public String[] getArgs() {
        if (this.strip) {
            return new String[]{"-s"};
        }
        return new String[0];
    }

    public boolean compatible(TestFile testFile) {
        if (testFile.version == 80) {
            return this.compatible(testFile.name);
        }
        return this.version >= testFile.version;
    }

    public boolean compatible(String string) {
        int n = 0;
        int n2 = string.indexOf(95);
        if (n2 != -1) {
            String string2 = string.substring(0, n2);
            try {
                n = Integer.parseInt(string2, 16);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n == 0 || this.version >= n;
    }

    private String getVersionString() {
        if (this.isDefault) {
            return "";
        }
        return Integer.toHexString(this.version);
    }

    private String getMinorVersionString() {
        if (this.minorVersion >= 0) {
            return Integer.toString(this.minorVersion);
        }
        return "";
    }

    private String getNumberFormatString() {
        switch (this.numberFormat.ordinal()) {
            case 0: {
                return "";
            }
            case 1: {
                return "_float";
            }
            case 2: {
                return "_int32";
            }
            case 3: {
                return "_int64";
            }
        }
        throw new IllegalStateException();
    }

    public static enum NumberFormat {
        DEFAULT,
        FLOAT,
        INT32,
        INT64;

    }
}

