/*
 * Decompiled with CFR 0.152.
 */
package unluac.test;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import unluac.Configuration;
import unluac.parse.BHeader;
import unluac.parse.LFunction;
import unluac.parse.LLocal;
import unluac.parse.LObject;

public class Compare {
    private final Mode mode;

    public Compare(Mode mode) {
        this.mode = mode;
    }

    public boolean bytecode_equal(String string, String string2) {
        LFunction lFunction = this.file_to_function(string);
        LFunction lFunction2 = this.file_to_function(string2);
        return this.function_equal(lFunction, lFunction2);
    }

    public boolean function_equal(LFunction lFunction, LFunction lFunction2) {
        int n;
        if (lFunction.maximumStackSize != lFunction2.maximumStackSize) {
            return false;
        }
        if (lFunction.numParams != lFunction2.numParams) {
            return false;
        }
        if (lFunction.numUpvalues != lFunction2.numUpvalues) {
            return false;
        }
        if (lFunction.vararg != lFunction2.vararg) {
            return false;
        }
        if (lFunction.code.length != lFunction2.code.length) {
            return false;
        }
        for (n = 0; n < lFunction.code.length; ++n) {
            if (lFunction.code[n] == lFunction2.code[n]) continue;
            return false;
        }
        if (lFunction.constants.length != lFunction2.constants.length) {
            return false;
        }
        for (n = 0; n < lFunction.constants.length; ++n) {
            if (this.object_equal(lFunction.constants[n], lFunction2.constants[n])) continue;
            return false;
        }
        if (lFunction.locals.length != lFunction2.locals.length) {
            return false;
        }
        for (n = 0; n < lFunction.locals.length; ++n) {
            if (this.local_equal(lFunction.locals[n], lFunction2.locals[n])) continue;
            return false;
        }
        if (lFunction.upvalues.length != lFunction2.upvalues.length) {
            return false;
        }
        for (n = 0; n < lFunction.upvalues.length; ++n) {
            if (lFunction.upvalues[n].equals(lFunction2.upvalues[n])) continue;
            return false;
        }
        if (lFunction.functions.length != lFunction2.functions.length) {
            return false;
        }
        for (n = 0; n < lFunction.functions.length; ++n) {
            if (this.function_equal(lFunction.functions[n], lFunction2.functions[n])) continue;
            return false;
        }
        if (this.mode == Mode.FULL) {
            if (!lFunction.name.equals(lFunction2.name)) {
                return false;
            }
            if (lFunction.linedefined != lFunction2.linedefined) {
                return false;
            }
            if (lFunction.lastlinedefined != lFunction2.lastlinedefined) {
                return false;
            }
            if (lFunction.lines.length != lFunction2.lines.length) {
                return false;
            }
            for (n = 0; n < lFunction.lines.length; ++n) {
                if (lFunction.lines[n] == lFunction2.lines[n]) continue;
                return false;
            }
            if (lFunction.abslineinfo == null != (lFunction2.abslineinfo == null)) {
                return false;
            }
            if (lFunction.abslineinfo != null) {
                if (lFunction.abslineinfo.length != lFunction2.abslineinfo.length) {
                    return false;
                }
                for (n = 0; n < lFunction.abslineinfo.length; ++n) {
                    if (lFunction.abslineinfo[n].equals(lFunction2.abslineinfo[n])) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public boolean object_equal(LObject lObject, LObject lObject2) {
        return lObject.equals(lObject2);
    }

    public boolean local_equal(LLocal lLocal, LLocal lLocal2) {
        if (lLocal.start != lLocal2.start) {
            return false;
        }
        if (lLocal.end != lLocal2.end) {
            return false;
        }
        return lLocal.name.equals(lLocal2.name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LFunction file_to_function(String string) {
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(string, "r");
            ByteBuffer byteBuffer = ByteBuffer.allocate((int)randomAccessFile.length());
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            FileChannel fileChannel = randomAccessFile.getChannel();
            for (int i = (int)randomAccessFile.length(); i > 0; i -= fileChannel.read(byteBuffer)) {
            }
            byteBuffer.rewind();
            BHeader bHeader = new BHeader(byteBuffer, new Configuration());
            LFunction lFunction = bHeader.main;
            return lFunction;
        }
        catch (IOException iOException) {
            LFunction lFunction = null;
            return lFunction;
        }
        finally {
            if (randomAccessFile != null) {
                try {
                    randomAccessFile.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static enum Mode {
        NORMAL,
        FULL;

    }
}

