/*
 * Decompiled with CFR 0.152.
 */
package unluac.parse;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import unluac.parse.BHeader;
import unluac.parse.BInteger;
import unluac.parse.LString;
import unluac.parse.LStringType;

class LStringType54
extends LStringType {
    LStringType54() {
    }

    @Override
    public LString parse(final ByteBuffer byteBuffer, BHeader bHeader) {
        BInteger bInteger = (BInteger)bHeader.sizeT.parse(byteBuffer, bHeader);
        if (bInteger.asInt() == 0) {
            return LString.NULL;
        }
        final StringBuilder stringBuilder = (StringBuilder)this.b.get();
        stringBuilder.setLength(0);
        bInteger.iterate(new Runnable(){
            boolean first = true;

            @Override
            public void run() {
                if (!this.first) {
                    stringBuilder.append((char)(0xFF & byteBuffer.get()));
                } else {
                    this.first = false;
                }
            }
        });
        String string = stringBuilder.toString();
        Objects.requireNonNull(bHeader);
        return new LString(string);
    }

    @Override
    public void write(OutputStream outputStream, BHeader bHeader, LString lString) throws IOException {
        if (lString == LString.NULL) {
            bHeader.sizeT.write(outputStream, bHeader, bHeader.sizeT.create(0));
        } else {
            bHeader.sizeT.write(outputStream, bHeader, bHeader.sizeT.create(lString.value.length() + 1));
            for (int i = 0; i < lString.value.length(); ++i) {
                outputStream.write(lString.value.charAt(i));
            }
        }
    }
}

