/*
 * Decompiled with CFR 0.152.
 */
package unluac.parse;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import unluac.Main;
import unluac.parse.BHeader;
import unluac.parse.BInteger;
import unluac.parse.LString;
import unluac.parse.LStringType;

class LStringType53
extends LStringType {
    private static int debugCounter = 0;

    LStringType53() {
    }

    @Override
    public LString parse(final ByteBuffer byteBuffer, BHeader bHeader) {
        BInteger bInteger;
        int n;
        int n2 = byteBuffer.position();
        int n3 = 0xFF & byteBuffer.get();
        if (n3 == 0) {
            return LString.NULL;
        }
        if (n3 == 255) {
            if (bHeader.lheader != null && bHeader.lheader.format == 1) {
                n = byteBuffer.getInt();
                bInteger = new BInteger(n);
            } else {
                bInteger = (BInteger)bHeader.sizeT.parse(byteBuffer, bHeader);
            }
        } else {
            bInteger = new BInteger(n3);
        }
        n = Main.currentFile != null && (Main.currentFile.contains("lw_guide_flow") || Main.currentFile.contains("lw_guide_flow_B")) ? 1 : 0;
        int n4 = -1;
        try {
            n4 = bInteger.asInt();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n != 0) {
            int n5 = debugCounter++;
            System.err.println(String.format("[TRACE][%s] LString #%d at 0x%08X: sizeByte=%d, sizeT=%d, remaining=%d", Main.currentFile, n5, n2, n3, n4, byteBuffer.remaining()));
        }
        final StringBuilder stringBuilder = (StringBuilder)this.b.get();
        stringBuilder.setLength(0);
        bInteger.iterate(new Runnable(){
            boolean first = true;

            @Override
            public void run() {
                if (!this.first) {
                    stringBuilder.append((char)(0xFF & byteBuffer.get()));
                } else {
                    this.first = false;
                }
            }
        });
        String string = stringBuilder.toString();
        Objects.requireNonNull(bHeader);
        return new LString(string);
    }

    @Override
    public void write(OutputStream outputStream, BHeader bHeader, LString lString) throws IOException {
        if (lString == LString.NULL) {
            outputStream.write(0);
        } else {
            int n = lString.value.length() + 1;
            if (n < 255) {
                outputStream.write((byte)n);
            } else {
                outputStream.write(255);
                bHeader.sizeT.write(outputStream, bHeader, bHeader.sizeT.create(n));
            }
            for (int i = 0; i < lString.value.length(); ++i) {
                outputStream.write(lString.value.charAt(i));
            }
        }
    }
}

