/*
 * Decompiled with CFR 0.152.
 */
package unluac.parse;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import unluac.parse.BHeader;
import unluac.parse.BInteger;
import unluac.parse.LString;
import unluac.parse.LStringType;

class LStringType50
extends LStringType {
    LStringType50() {
    }

    @Override
    public LString parse(final ByteBuffer byteBuffer, BHeader bHeader) {
        BInteger bInteger = (BInteger)bHeader.sizeT.parse(byteBuffer, bHeader);
        final StringBuilder stringBuilder = (StringBuilder)this.b.get();
        stringBuilder.setLength(0);
        bInteger.iterate(new Runnable(){

            @Override
            public void run() {
                stringBuilder.append((char)(0xFF & byteBuffer.get()));
            }
        });
        if (stringBuilder.length() == 0) {
            return LString.NULL;
        }
        char c = stringBuilder.charAt(stringBuilder.length() - 1);
        stringBuilder.delete(stringBuilder.length() - 1, stringBuilder.length());
        String string = stringBuilder.toString();
        Objects.requireNonNull(bHeader);
        return new LString(string, c);
    }

    @Override
    public void write(OutputStream outputStream, BHeader bHeader, LString lString) throws IOException {
        int n = lString.value.length();
        if (lString == LString.NULL) {
            bHeader.sizeT.write(outputStream, bHeader, bHeader.sizeT.create(0));
        } else {
            bHeader.sizeT.write(outputStream, bHeader, bHeader.sizeT.create(n + 1));
            for (int i = 0; i < n; ++i) {
                outputStream.write(lString.value.charAt(i));
            }
            outputStream.write(0);
        }
    }
}

