/*
 * Decompiled with CFR 0.152.
 */
package unluac.parse;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Objects;
import unluac.parse.BHeader;
import unluac.parse.BObjectType;
import unluac.parse.LDoubleNumber;
import unluac.parse.LFloatNumber;
import unluac.parse.LHeader;
import unluac.parse.LIntNumber;
import unluac.parse.LLongNumber;
import unluac.parse.LNumber;

public class LNumberType
extends BObjectType<LNumber> {
    public final int size;
    public final boolean integral;
    public final NumberMode mode;

    public LNumberType(int n, boolean bl, NumberMode numberMode) {
        this.size = n;
        this.integral = bl;
        this.mode = numberMode;
        if (n != 4 && n != 8) {
            throw new IllegalStateException("The input chunk has an unsupported Lua number size: " + n);
        }
    }

    public double convert(double d) {
        if (this.integral) {
            switch (this.size) {
                case 4: {
                    return (int)d;
                }
                case 8: {
                    return (long)d;
                }
            }
        } else {
            switch (this.size) {
                case 4: {
                    return (float)d;
                }
                case 8: {
                    return d;
                }
            }
        }
        throw new IllegalStateException("The input chunk has an unsupported Lua number format");
    }

    @Override
    public LNumber parse(ByteBuffer byteBuffer, BHeader bHeader) {
        LNumber lNumber = null;
        if (this.integral) {
            switch (this.size) {
                case 4: {
                    lNumber = new LIntNumber(byteBuffer.getInt());
                    break;
                }
                case 8: {
                    lNumber = new LLongNumber(byteBuffer.getLong());
                }
            }
        } else {
            switch (this.size) {
                case 4: {
                    lNumber = new LFloatNumber(byteBuffer.getFloat(), this.mode);
                    break;
                }
                case 8: {
                    lNumber = new LDoubleNumber(byteBuffer.getDouble(), this.mode);
                }
            }
        }
        if (lNumber == null) {
            throw new IllegalStateException("The input chunk has an unsupported Lua number format");
        }
        Objects.requireNonNull(bHeader);
        return lNumber;
    }

    @Override
    public void write(OutputStream outputStream, BHeader bHeader, LNumber lNumber) throws IOException {
        long l = lNumber.bits();
        if (bHeader.lheader.endianness == LHeader.LEndianness.LITTLE) {
            for (int i = 0; i < this.size; ++i) {
                outputStream.write((byte)(l & 0xFFL));
                l >>>= 8;
            }
        } else {
            for (int i = this.size - 1; i >= 0; --i) {
                outputStream.write((byte)(l >> i * 8 & 0xFFL));
            }
        }
    }

    public LNumber createNaN(long l) {
        if (this.integral) {
            throw new IllegalStateException();
        }
        switch (this.size) {
            case 4: {
                int n = Float.floatToRawIntBits(Float.NaN);
                if (l < 0L) {
                    l ^= Long.MIN_VALUE;
                    n ^= Integer.MIN_VALUE;
                }
                n = (int)((long)n | l >> 29);
                return new LFloatNumber(Float.intBitsToFloat(n), this.mode);
            }
            case 8: {
                return new LDoubleNumber(Double.longBitsToDouble(Double.doubleToRawLongBits(Double.NaN) ^ l), this.mode);
            }
        }
        throw new IllegalStateException();
    }

    public LNumber create(double d) {
        if (this.integral) {
            switch (this.size) {
                case 4: {
                    return new LIntNumber((int)d);
                }
                case 8: {
                    return new LLongNumber((long)d);
                }
            }
            throw new IllegalStateException();
        }
        switch (this.size) {
            case 4: {
                return new LFloatNumber((float)d, this.mode);
            }
            case 8: {
                return new LDoubleNumber(d, this.mode);
            }
        }
        throw new IllegalStateException();
    }

    public LNumber create(BigInteger bigInteger) {
        if (this.integral) {
            switch (this.size) {
                case 4: {
                    return new LIntNumber(bigInteger.intValueExact());
                }
                case 8: {
                    return new LLongNumber(bigInteger.longValueExact());
                }
            }
            throw new IllegalStateException();
        }
        switch (this.size) {
            case 4: {
                return new LFloatNumber(bigInteger.floatValue(), this.mode);
            }
            case 8: {
                return new LDoubleNumber(bigInteger.doubleValue(), this.mode);
            }
        }
        throw new IllegalStateException();
    }

    public static enum NumberMode {
        MODE_NUMBER,
        MODE_FLOAT,
        MODE_INTEGER;

    }
}

