/*
 * Decompiled with CFR 0.152.
 */
package unluac.parse;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import unluac.parse.BHeader;
import unluac.parse.BInteger;
import unluac.parse.BObjectType;
import unluac.parse.LLocal;
import unluac.parse.LString;

public class LLocalType
extends BObjectType<LLocal> {
    @Override
    public LLocal parse(ByteBuffer byteBuffer, BHeader bHeader) {
        LString lString = (LString)bHeader.string.parse(byteBuffer, bHeader);
        BInteger bInteger = (BInteger)bHeader.integer.parse(byteBuffer, bHeader);
        BInteger bInteger2 = (BInteger)bHeader.integer.parse(byteBuffer, bHeader);
        Objects.requireNonNull(bHeader);
        return new LLocal(lString, bInteger, bInteger2);
    }

    @Override
    public void write(OutputStream outputStream, BHeader bHeader, LLocal lLocal) throws IOException {
        bHeader.string.write(outputStream, bHeader, lLocal.name);
        bHeader.integer.write(outputStream, bHeader, new BInteger(lLocal.start));
        bHeader.integer.write(outputStream, bHeader, new BInteger(lLocal.end));
    }
}

