/*
 * Decompiled with CFR 0.152.
 */
package unluac.parse;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import unluac.assemble.Directive;
import unluac.parse.BHeader;
import unluac.parse.LHeader;
import unluac.parse.LHeaderType;
import unluac.parse.LNumberType;

class LHeaderType50
extends LHeaderType {
    private static final double TEST_NUMBER = 3.1415926535897933E7;

    LHeaderType50() {
    }

    @Override
    protected void parse_main(ByteBuffer byteBuffer, BHeader bHeader, LHeaderType.LHeaderParseState lHeaderParseState) {
        lHeaderParseState.format = 0;
        this.parse_endianness(byteBuffer, bHeader, lHeaderParseState);
        this.parse_int_size(byteBuffer, bHeader, lHeaderParseState);
        this.parse_size_t_size(byteBuffer, bHeader, lHeaderParseState);
        this.parse_instruction_size(byteBuffer, bHeader, lHeaderParseState);
        this.parse_extractor(byteBuffer, bHeader, lHeaderParseState);
        this.parse_number_size(byteBuffer, bHeader, lHeaderParseState);
        LNumberType lNumberType = new LNumberType(lHeaderParseState.lNumberSize, false, LNumberType.NumberMode.MODE_NUMBER);
        LNumberType lNumberType2 = new LNumberType(lHeaderParseState.lNumberSize, true, LNumberType.NumberMode.MODE_NUMBER);
        byteBuffer.mark();
        double d = lNumberType.parse(byteBuffer, bHeader).value();
        byteBuffer.reset();
        double d2 = lNumberType2.parse(byteBuffer, bHeader).value();
        if (d == lNumberType.convert(3.1415926535897933E7)) {
            lHeaderParseState.number = lNumberType;
        } else if (d2 == lNumberType2.convert(3.1415926535897933E7)) {
            lHeaderParseState.number = lNumberType2;
        } else {
            throw new IllegalStateException("The input chunk is using an unrecognized number format: " + d2);
        }
    }

    @Override
    public List<Directive> get_directives() {
        return Arrays.asList(Directive.ENDIANNESS, Directive.INT_SIZE, Directive.SIZE_T_SIZE, Directive.INSTRUCTION_SIZE, Directive.SIZE_OP, Directive.SIZE_A, Directive.SIZE_B, Directive.SIZE_C, Directive.NUMBER_FORMAT);
    }

    @Override
    public void write(OutputStream outputStream, BHeader bHeader, LHeader lHeader) throws IOException {
        this.write_endianness(outputStream, bHeader, lHeader);
        this.write_int_size(outputStream, bHeader, lHeader);
        this.write_size_t_size(outputStream, bHeader, lHeader);
        this.write_instruction_size(outputStream, bHeader, lHeader);
        this.write_extractor(outputStream, bHeader, lHeader);
        this.write_number_size(outputStream, bHeader, lHeader);
        lHeader.number.write(outputStream, bHeader, lHeader.number.create(3.1415926535897933E7));
    }
}

