/*
 * Decompiled with CFR 0.152.
 */
package unluac.parse;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import unluac.Version;
import unluac.assemble.Directive;
import unluac.decompile.CodeExtract;
import unluac.parse.BHeader;
import unluac.parse.BIntegerType;
import unluac.parse.BIntegerType50;
import unluac.parse.BObjectType;
import unluac.parse.LAbsLineInfoType;
import unluac.parse.LBooleanType;
import unluac.parse.LConstantType;
import unluac.parse.LFunctionType;
import unluac.parse.LHeader;
import unluac.parse.LHeaderType50;
import unluac.parse.LHeaderType51;
import unluac.parse.LHeaderType52;
import unluac.parse.LHeaderType53;
import unluac.parse.LHeaderType54;
import unluac.parse.LLocalType;
import unluac.parse.LNumberType;
import unluac.parse.LStringType;
import unluac.parse.LUpvalueType;

public abstract class LHeaderType
extends BObjectType<LHeader> {
    public static final LHeaderType TYPE50 = new LHeaderType50();
    public static final LHeaderType TYPE51 = new LHeaderType51();
    public static final LHeaderType TYPE52 = new LHeaderType52();
    public static final LHeaderType TYPE53 = new LHeaderType53();
    public static final LHeaderType TYPE54 = new LHeaderType54();
    private static final byte[] luacTail = new byte[]{25, -109, 13, 10, 26, 10};
    protected static final int TEST_INTEGER = 22136;
    protected static final double TEST_FLOAT = 370.5;

    public static LHeaderType get(Version.HeaderType headerType) {
        switch (headerType) {
            case LUA50: {
                return TYPE50;
            }
            case LUA51: {
                return TYPE51;
            }
            case LUA52: {
                return TYPE52;
            }
            case LUA53: {
                return TYPE53;
            }
            case LUA54: {
                return TYPE54;
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public LHeader parse(ByteBuffer byteBuffer, BHeader bHeader) {
        Version version = bHeader.version;
        LHeaderParseState lHeaderParseState = new LHeaderParseState();
        this.parse_main(byteBuffer, bHeader, lHeaderParseState);
        LBooleanType lBooleanType = new LBooleanType();
        LStringType lStringType = version.getLStringType();
        LConstantType lConstantType = version.getLConstantType();
        LAbsLineInfoType lAbsLineInfoType = new LAbsLineInfoType();
        LLocalType lLocalType = new LLocalType();
        LUpvalueType lUpvalueType = version.getLUpvalueType();
        LFunctionType lFunctionType = version.getLFunctionType();
        CodeExtract codeExtract = new CodeExtract(bHeader.version, lHeaderParseState.sizeOp, lHeaderParseState.sizeA, lHeaderParseState.sizeB, lHeaderParseState.sizeC);
        return new LHeader(lHeaderParseState.format, lHeaderParseState.endianness, lHeaderParseState.integer, lHeaderParseState.sizeT, lBooleanType, lHeaderParseState.number, lHeaderParseState.linteger, lHeaderParseState.lfloat, lStringType, lConstantType, lAbsLineInfoType, lLocalType, lUpvalueType, lFunctionType, codeExtract);
    }

    public abstract List<Directive> get_directives();

    protected abstract void parse_main(ByteBuffer var1, BHeader var2, LHeaderParseState var3);

    protected void parse_format(ByteBuffer byteBuffer, BHeader bHeader, LHeaderParseState lHeaderParseState) {
        int n = 0xFF & byteBuffer.get();
        if (n != 0 && n != 1) {
            throw new IllegalStateException("The input chunk reports a non-standard lua format: " + n);
        }
        lHeaderParseState.format = n;
        Objects.requireNonNull(bHeader);
    }

    protected void write_format(OutputStream outputStream, BHeader bHeader, LHeader lHeader) throws IOException {
        outputStream.write(lHeader.format);
    }

    protected void parse_endianness(ByteBuffer byteBuffer, BHeader bHeader, LHeaderParseState lHeaderParseState) {
        int n = 0xFF & byteBuffer.get();
        switch (n) {
            case 0: {
                lHeaderParseState.endianness = LHeader.LEndianness.BIG;
                byteBuffer.order(ByteOrder.BIG_ENDIAN);
                break;
            }
            case 1: {
                lHeaderParseState.endianness = LHeader.LEndianness.LITTLE;
                byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                break;
            }
            default: {
                throw new IllegalStateException("The input chunk reports an invalid endianness: " + n);
            }
        }
        Objects.requireNonNull(bHeader);
    }

    protected void write_endianness(OutputStream outputStream, BHeader bHeader, LHeader lHeader) throws IOException {
        outputStream.write(switch (lHeader.endianness) {
            case LHeader.LEndianness.BIG -> 0;
            case LHeader.LEndianness.LITTLE -> 1;
            default -> throw new IllegalStateException();
        });
    }

    protected void parse_int_size(ByteBuffer byteBuffer, BHeader bHeader, LHeaderParseState lHeaderParseState) {
        int n = 0xFF & byteBuffer.get();
        Objects.requireNonNull(bHeader);
        lHeaderParseState.integer = new BIntegerType50(true, n, bHeader.version.allownegativeint.get());
    }

    protected void write_int_size(OutputStream outputStream, BHeader bHeader, LHeader lHeader) throws IOException {
        outputStream.write(lHeader.integer.getSize());
    }

    protected void parse_size_t_size(ByteBuffer byteBuffer, BHeader bHeader, LHeaderParseState lHeaderParseState) {
        int n = 0xFF & byteBuffer.get();
        Objects.requireNonNull(bHeader);
        lHeaderParseState.sizeT = new BIntegerType50(false, n, false);
    }

    protected void write_size_t_size(OutputStream outputStream, BHeader bHeader, LHeader lHeader) throws IOException {
        outputStream.write(lHeader.sizeT.getSize());
    }

    protected void parse_instruction_size(ByteBuffer byteBuffer, BHeader bHeader, LHeaderParseState lHeaderParseState) {
        int n = 0xFF & byteBuffer.get();
        Objects.requireNonNull(bHeader);
        if (n != 4) {
            throw new IllegalStateException("The input chunk reports an unsupported instruction size: " + n + " bytes");
        }
    }

    protected void write_instruction_size(OutputStream outputStream, BHeader bHeader, LHeader lHeader) throws IOException {
        outputStream.write(4);
    }

    protected void parse_number_size(ByteBuffer byteBuffer, BHeader bHeader, LHeaderParseState lHeaderParseState) {
        int n = 0xFF & byteBuffer.get();
        Objects.requireNonNull(bHeader);
        lHeaderParseState.lNumberSize = n;
    }

    protected void write_number_size(OutputStream outputStream, BHeader bHeader, LHeader lHeader) throws IOException {
        outputStream.write(lHeader.number.size);
    }

    protected void parse_number_integrality(ByteBuffer byteBuffer, BHeader bHeader, LHeaderParseState lHeaderParseState) {
        int n = 0xFF & byteBuffer.get();
        Objects.requireNonNull(bHeader);
        if (n > 1) {
            throw new IllegalStateException("The input chunk reports an invalid code for lua number integrality: " + n);
        }
        lHeaderParseState.lNumberIntegrality = n == 1;
    }

    protected void write_number_integrality(OutputStream outputStream, BHeader bHeader, LHeader lHeader) throws IOException {
        outputStream.write((byte)(lHeader.number.integral ? 1 : 0));
    }

    protected void parse_integer_size(ByteBuffer byteBuffer, BHeader bHeader, LHeaderParseState lHeaderParseState) {
        int n = 0xFF & byteBuffer.get();
        Objects.requireNonNull(bHeader);
        if (n < 2) {
            throw new IllegalStateException("The input chunk reports an integer size that is too small: " + n);
        }
        lHeaderParseState.lIntegerSize = n;
    }

    protected void parse_float_size(ByteBuffer byteBuffer, BHeader bHeader, LHeaderParseState lHeaderParseState) {
        int n = 0xFF & byteBuffer.get();
        Objects.requireNonNull(bHeader);
        lHeaderParseState.lFloatSize = n;
    }

    protected void parse_number_format_53(ByteBuffer byteBuffer, BHeader bHeader, LHeaderParseState lHeaderParseState) {
        byte[] byArray = new byte[lHeaderParseState.lIntegerSize];
        byteBuffer.get(byArray);
        byte by = 86;
        byte by2 = 120;
        if (byArray[0] == by2 && byArray[1] == by) {
            lHeaderParseState.endianness = LHeader.LEndianness.LITTLE;
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        } else if (byArray[lHeaderParseState.lIntegerSize - 1] == by2 && byArray[lHeaderParseState.lIntegerSize - 2] == by) {
            lHeaderParseState.endianness = LHeader.LEndianness.BIG;
            byteBuffer.order(ByteOrder.BIG_ENDIAN);
        } else {
            throw new IllegalStateException("The input chunk reports an invalid endianness: " + Arrays.toString(byArray));
        }
        lHeaderParseState.linteger = new LNumberType(lHeaderParseState.lIntegerSize, true, LNumberType.NumberMode.MODE_INTEGER);
        lHeaderParseState.lfloat = new LNumberType(lHeaderParseState.lFloatSize, false, LNumberType.NumberMode.MODE_FLOAT);
        double d = lHeaderParseState.lfloat.parse(byteBuffer, bHeader).value();
        if (d != lHeaderParseState.lfloat.convert(370.5)) {
            throw new IllegalStateException("The input chunk is using an unrecognized floating point format: " + d);
        }
    }

    protected void parse_extractor(ByteBuffer byteBuffer, BHeader bHeader, LHeaderParseState lHeaderParseState) {
        lHeaderParseState.sizeOp = 0xFF & byteBuffer.get();
        lHeaderParseState.sizeA = 0xFF & byteBuffer.get();
        lHeaderParseState.sizeB = 0xFF & byteBuffer.get();
        lHeaderParseState.sizeC = 0xFF & byteBuffer.get();
        Objects.requireNonNull(bHeader);
    }

    protected void write_extractor(OutputStream outputStream, BHeader bHeader, LHeader lHeader) throws IOException {
        outputStream.write(lHeader.extractor.op.size);
        outputStream.write(lHeader.extractor.A.size);
        outputStream.write(lHeader.extractor.B.size);
        outputStream.write(lHeader.extractor.C.size);
    }

    protected void parse_tail(ByteBuffer byteBuffer, BHeader bHeader, LHeaderParseState lHeaderParseState) {
        for (int i = 0; i < luacTail.length; ++i) {
            if (byteBuffer.get() == luacTail[i]) continue;
            throw new IllegalStateException("The input file does not have the header tail of a valid Lua file (it may be corrupted).");
        }
    }

    protected void write_tail(OutputStream outputStream, BHeader bHeader, LHeader lHeader) throws IOException {
        for (int i = 0; i < luacTail.length; ++i) {
            outputStream.write(luacTail[i]);
        }
    }

    protected static class LHeaderParseState {
        BIntegerType integer;
        BIntegerType sizeT;
        LNumberType number;
        LNumberType linteger;
        LNumberType lfloat;
        int format;
        LHeader.LEndianness endianness;
        int lNumberSize;
        boolean lNumberIntegrality;
        int lIntegerSize;
        int lFloatSize;
        int sizeOp;
        int sizeA;
        int sizeB;
        int sizeC;

        protected LHeaderParseState() {
        }
    }
}

