/*
 * Decompiled with CFR 0.152.
 */
package unluac.parse;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import unluac.assemble.Directive;
import unluac.parse.BHeader;
import unluac.parse.BInteger;
import unluac.parse.BIntegerType50;
import unluac.parse.LFunction;
import unluac.parse.LFunctionType;
import unluac.parse.LString;
import unluac.parse.LUpvalue;

class LFunctionType54
extends LFunctionType {
    LFunctionType54() {
    }

    @Override
    protected void parse_debug(ByteBuffer byteBuffer, BHeader bHeader, LFunctionType.LFunctionParseState lFunctionParseState) {
        lFunctionParseState.lines = new BIntegerType50(false, 1, false).parseList(byteBuffer, bHeader);
        lFunctionParseState.abslineinfo = bHeader.abslineinfo.parseList(byteBuffer, bHeader);
        lFunctionParseState.locals = bHeader.local.parseList(byteBuffer, bHeader);
        this.parse_upvalue_names(byteBuffer, bHeader, lFunctionParseState);
    }

    @Override
    protected void write_debug(OutputStream outputStream, BHeader bHeader, LFunction lFunction) throws IOException {
        int n;
        bHeader.integer.write(outputStream, bHeader, new BInteger(lFunction.lines.length));
        for (n = 0; n < lFunction.lines.length; ++n) {
            outputStream.write(lFunction.lines[n]);
        }
        bHeader.abslineinfo.writeList(outputStream, bHeader, lFunction.abslineinfo);
        bHeader.local.writeList(outputStream, bHeader, lFunction.locals);
        n = 0;
        for (LUpvalue lUpvalue : lFunction.upvalues) {
            if (lUpvalue.bname == null || lUpvalue.bname == LString.NULL) break;
            ++n;
        }
        bHeader.integer.write(outputStream, bHeader, new BInteger(n));
        for (int i = 0; i < n; ++i) {
            bHeader.string.write(outputStream, bHeader, lFunction.upvalues[i].bname);
        }
    }

    @Override
    protected void parse_main(ByteBuffer byteBuffer, BHeader bHeader, LFunctionType.LFunctionParseState lFunctionParseState) {
        lFunctionParseState.name = (LString)bHeader.string.parse(byteBuffer, bHeader);
        lFunctionParseState.lineBegin = ((BInteger)bHeader.integer.parse(byteBuffer, bHeader)).asInt();
        lFunctionParseState.lineEnd = ((BInteger)bHeader.integer.parse(byteBuffer, bHeader)).asInt();
        lFunctionParseState.lenParameter = 0xFF & byteBuffer.get();
        lFunctionParseState.vararg = 0xFF & byteBuffer.get();
        lFunctionParseState.maximumStackSize = 0xFF & byteBuffer.get();
        this.parse_code(byteBuffer, bHeader, lFunctionParseState);
        lFunctionParseState.constants = bHeader.constant.parseList(byteBuffer, bHeader);
        this.parse_upvalues(byteBuffer, bHeader, lFunctionParseState);
        lFunctionParseState.functions = bHeader.function.parseList(byteBuffer, bHeader);
        this.parse_debug(byteBuffer, bHeader, lFunctionParseState);
    }

    @Override
    public List<Directive> get_directives() {
        return Arrays.asList(Directive.SOURCE, Directive.LINEDEFINED, Directive.LASTLINEDEFINED, Directive.NUMPARAMS, Directive.IS_VARARG, Directive.MAXSTACKSIZE);
    }

    @Override
    public void write(OutputStream outputStream, BHeader bHeader, LFunction lFunction) throws IOException {
        bHeader.string.write(outputStream, bHeader, lFunction.name);
        bHeader.integer.write(outputStream, bHeader, new BInteger(lFunction.linedefined));
        bHeader.integer.write(outputStream, bHeader, new BInteger(lFunction.lastlinedefined));
        outputStream.write(lFunction.numParams);
        outputStream.write(lFunction.vararg);
        outputStream.write(lFunction.maximumStackSize);
        this.write_code(outputStream, bHeader, lFunction);
        bHeader.constant.writeList(outputStream, bHeader, lFunction.constants);
        this.write_upvalues(outputStream, bHeader, lFunction);
        bHeader.function.writeList(outputStream, bHeader, lFunction.functions);
        this.write_debug(outputStream, bHeader, lFunction);
    }
}

