/*
 * Decompiled with CFR 0.152.
 */
package unluac.parse;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import unluac.assemble.Directive;
import unluac.parse.BHeader;
import unluac.parse.BInteger;
import unluac.parse.LFunction;
import unluac.parse.LFunctionType;
import unluac.parse.LString;

class LFunctionType52
extends LFunctionType {
    LFunctionType52() {
    }

    @Override
    protected void parse_main(ByteBuffer byteBuffer, BHeader bHeader, LFunctionType.LFunctionParseState lFunctionParseState) {
        lFunctionParseState.lineBegin = ((BInteger)bHeader.integer.parse(byteBuffer, bHeader)).asInt();
        lFunctionParseState.lineEnd = ((BInteger)bHeader.integer.parse(byteBuffer, bHeader)).asInt();
        lFunctionParseState.lenParameter = 0xFF & byteBuffer.get();
        lFunctionParseState.vararg = 0xFF & byteBuffer.get();
        lFunctionParseState.maximumStackSize = 0xFF & byteBuffer.get();
        this.parse_code(byteBuffer, bHeader, lFunctionParseState);
        this.parse_constants(byteBuffer, bHeader, lFunctionParseState);
        this.parse_upvalues(byteBuffer, bHeader, lFunctionParseState);
        lFunctionParseState.name = (LString)bHeader.string.parse(byteBuffer, bHeader);
        this.parse_debug(byteBuffer, bHeader, lFunctionParseState);
    }

    @Override
    public List<Directive> get_directives() {
        return Arrays.asList(Directive.LINEDEFINED, Directive.LASTLINEDEFINED, Directive.NUMPARAMS, Directive.IS_VARARG, Directive.MAXSTACKSIZE, Directive.SOURCE);
    }

    @Override
    public void write(OutputStream outputStream, BHeader bHeader, LFunction lFunction) throws IOException {
        bHeader.integer.write(outputStream, bHeader, new BInteger(lFunction.linedefined));
        bHeader.integer.write(outputStream, bHeader, new BInteger(lFunction.lastlinedefined));
        outputStream.write(lFunction.numParams);
        outputStream.write(lFunction.vararg);
        outputStream.write(lFunction.maximumStackSize);
        this.write_code(outputStream, bHeader, lFunction);
        this.write_constants(outputStream, bHeader, lFunction);
        this.write_upvalues(outputStream, bHeader, lFunction);
        bHeader.string.write(outputStream, bHeader, lFunction.name);
        this.write_debug(outputStream, bHeader, lFunction);
    }
}

