/*
 * Decompiled with CFR 0.152.
 */
package unluac.parse;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import unluac.assemble.Directive;
import unluac.parse.BHeader;
import unluac.parse.BInteger;
import unluac.parse.LFunction;
import unluac.parse.LFunctionType;
import unluac.parse.LString;

class LFunctionType50
extends LFunctionType {
    LFunctionType50() {
    }

    @Override
    protected void parse_main(ByteBuffer byteBuffer, BHeader bHeader, LFunctionType.LFunctionParseState lFunctionParseState) {
        lFunctionParseState.name = (LString)bHeader.string.parse(byteBuffer, bHeader);
        lFunctionParseState.lineBegin = ((BInteger)bHeader.integer.parse(byteBuffer, bHeader)).asInt();
        lFunctionParseState.lineEnd = 0;
        lFunctionParseState.lenUpvalues = 0xFF & byteBuffer.get();
        this.create_upvalues(byteBuffer, bHeader, lFunctionParseState);
        lFunctionParseState.lenParameter = 0xFF & byteBuffer.get();
        lFunctionParseState.vararg = 0xFF & byteBuffer.get();
        lFunctionParseState.maximumStackSize = 0xFF & byteBuffer.get();
        this.parse_debug(byteBuffer, bHeader, lFunctionParseState);
        this.parse_constants(byteBuffer, bHeader, lFunctionParseState);
        this.parse_code(byteBuffer, bHeader, lFunctionParseState);
    }

    @Override
    public List<Directive> get_directives() {
        return Arrays.asList(Directive.SOURCE, Directive.LINEDEFINED, Directive.NUMPARAMS, Directive.IS_VARARG, Directive.MAXSTACKSIZE);
    }

    @Override
    public void write(OutputStream outputStream, BHeader bHeader, LFunction lFunction) throws IOException {
        bHeader.string.write(outputStream, bHeader, lFunction.name);
        bHeader.integer.write(outputStream, bHeader, new BInteger(lFunction.linedefined));
        outputStream.write(lFunction.numUpvalues);
        outputStream.write(lFunction.numParams);
        outputStream.write(lFunction.vararg);
        outputStream.write(lFunction.maximumStackSize);
        this.write_debug(outputStream, bHeader, lFunction);
        this.write_constants(outputStream, bHeader, lFunction);
        this.write_code(outputStream, bHeader, lFunction);
    }
}

