/*
 * Decompiled with CFR 0.152.
 */
package unluac.parse;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import unluac.Version;
import unluac.assemble.Directive;
import unluac.parse.BHeader;
import unluac.parse.BInteger;
import unluac.parse.BList;
import unluac.parse.BObjectType;
import unluac.parse.LAbsLineInfo;
import unluac.parse.LFunction;
import unluac.parse.LFunctionType50;
import unluac.parse.LFunctionType51;
import unluac.parse.LFunctionType52;
import unluac.parse.LFunctionType53;
import unluac.parse.LFunctionType54;
import unluac.parse.LHeader;
import unluac.parse.LLocal;
import unluac.parse.LObject;
import unluac.parse.LString;
import unluac.parse.LUpvalue;

public abstract class LFunctionType
extends BObjectType<LFunction> {
    public static LFunctionType get(Version.FunctionType functionType) {
        switch (functionType) {
            case LUA50: {
                return new LFunctionType50();
            }
            case LUA51: {
                return new LFunctionType51();
            }
            case LUA52: {
                return new LFunctionType52();
            }
            case LUA53: {
                return new LFunctionType53();
            }
            case LUA54: {
                return new LFunctionType54();
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public LFunction parse(ByteBuffer byteBuffer, BHeader bHeader) {
        Objects.requireNonNull(bHeader);
        Objects.requireNonNull(bHeader);
        LFunctionParseState lFunctionParseState = new LFunctionParseState();
        this.parse_main(byteBuffer, bHeader, lFunctionParseState);
        int[] nArray = new int[lFunctionParseState.lines.length.asInt()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = lFunctionParseState.lines.get(i).asInt();
        }
        LAbsLineInfo[] lAbsLineInfoArray = null;
        if (lFunctionParseState.abslineinfo != null) {
            lAbsLineInfoArray = (LAbsLineInfo[])lFunctionParseState.abslineinfo.asArray(new LAbsLineInfo[lFunctionParseState.abslineinfo.length.asInt()]);
        }
        LFunction lFunction = new LFunction(bHeader, lFunctionParseState.name, lFunctionParseState.lineBegin, lFunctionParseState.lineEnd, lFunctionParseState.code, nArray, lAbsLineInfoArray, (LLocal[])lFunctionParseState.locals.asArray(new LLocal[Math.max(0, lFunctionParseState.locals.length.asInt())]), (LObject[])lFunctionParseState.constants.asArray(new LObject[Math.max(0, lFunctionParseState.constants.length.asInt())]), lFunctionParseState.upvalues, (LFunction[])lFunctionParseState.functions.asArray(new LFunction[Math.max(0, lFunctionParseState.functions.length.asInt())]), lFunctionParseState.maximumStackSize, lFunctionParseState.lenUpvalues, lFunctionParseState.lenParameter, lFunctionParseState.vararg);
        for (LFunction lFunction2 : lFunction.functions) {
            lFunction2.parent = lFunction;
        }
        if (lFunctionParseState.lines.length.asInt() == 0 && lFunctionParseState.locals.length.asInt() == 0) {
            lFunction.stripped = true;
        }
        return lFunction;
    }

    public abstract List<Directive> get_directives();

    protected abstract void parse_main(ByteBuffer var1, BHeader var2, LFunctionParseState var3);

    protected void parse_code(ByteBuffer byteBuffer, BHeader bHeader, LFunctionParseState lFunctionParseState) {
        Objects.requireNonNull(bHeader);
        lFunctionParseState.length = ((BInteger)bHeader.integer.parse(byteBuffer, bHeader)).asInt();
        lFunctionParseState.code = new int[lFunctionParseState.length];
        for (int i = 0; i < lFunctionParseState.length; ++i) {
            lFunctionParseState.code[i] = byteBuffer.getInt();
            Objects.requireNonNull(bHeader);
        }
    }

    protected void write_code(OutputStream outputStream, BHeader bHeader, LFunction lFunction) throws IOException {
        bHeader.integer.write(outputStream, bHeader, new BInteger(lFunction.code.length));
        for (int i = 0; i < lFunction.code.length; ++i) {
            int n = lFunction.code[i];
            if (bHeader.lheader.endianness == LHeader.LEndianness.LITTLE) {
                outputStream.write((byte)(0xFF & n));
                outputStream.write((byte)(0xFF & n >> 8));
                outputStream.write((byte)(0xFF & n >> 16));
                outputStream.write((byte)(0xFF & n >> 24));
                continue;
            }
            outputStream.write((byte)(0xFF & n >> 24));
            outputStream.write((byte)(0xFF & n >> 16));
            outputStream.write((byte)(0xFF & n >> 8));
            outputStream.write((byte)(0xFF & n));
        }
    }

    protected void parse_constants(ByteBuffer byteBuffer, BHeader bHeader, LFunctionParseState lFunctionParseState) {
        Objects.requireNonNull(bHeader);
        lFunctionParseState.constants = bHeader.constant.parseList(byteBuffer, bHeader);
        Objects.requireNonNull(bHeader);
        lFunctionParseState.functions = bHeader.function.parseList(byteBuffer, bHeader);
    }

    protected void write_constants(OutputStream outputStream, BHeader bHeader, LFunction lFunction) throws IOException {
        bHeader.constant.writeList(outputStream, bHeader, lFunction.constants);
        bHeader.function.writeList(outputStream, bHeader, lFunction.functions);
    }

    protected void create_upvalues(ByteBuffer byteBuffer, BHeader bHeader, LFunctionParseState lFunctionParseState) {
        lFunctionParseState.upvalues = new LUpvalue[lFunctionParseState.lenUpvalues];
        for (int i = 0; i < lFunctionParseState.lenUpvalues; ++i) {
            lFunctionParseState.upvalues[i] = new LUpvalue();
        }
    }

    protected void parse_upvalues(ByteBuffer byteBuffer, BHeader bHeader, LFunctionParseState lFunctionParseState) {
        BList bList = bHeader.upvalue.parseList(byteBuffer, bHeader);
        lFunctionParseState.lenUpvalues = bList.length.asInt();
        lFunctionParseState.upvalues = (LUpvalue[])bList.asArray(new LUpvalue[lFunctionParseState.lenUpvalues]);
    }

    protected void write_upvalues(OutputStream outputStream, BHeader bHeader, LFunction lFunction) throws IOException {
        bHeader.upvalue.writeList(outputStream, bHeader, lFunction.upvalues);
    }

    protected void parse_debug(ByteBuffer byteBuffer, BHeader bHeader, LFunctionParseState lFunctionParseState) {
        Objects.requireNonNull(bHeader);
        lFunctionParseState.lines = bHeader.integer.parseList(byteBuffer, bHeader);
        Objects.requireNonNull(bHeader);
        lFunctionParseState.locals = bHeader.local.parseList(byteBuffer, bHeader, bHeader.version.locallengthmode.get());
        this.parse_upvalue_names(byteBuffer, bHeader, lFunctionParseState);
    }

    protected void parse_upvalue_names(ByteBuffer byteBuffer, BHeader bHeader, LFunctionParseState lFunctionParseState) {
        Objects.requireNonNull(bHeader);
        BList bList = bHeader.string.parseList(byteBuffer, bHeader, bHeader.version.upvaluelengthmode.get(), new BInteger(lFunctionParseState.lenUpvalues));
        for (int i = 0; i < Math.min(lFunctionParseState.upvalues.length, bList.length.asInt()); ++i) {
            lFunctionParseState.upvalues[i].bname = (LString)bList.get(i);
            lFunctionParseState.upvalues[i].name = lFunctionParseState.upvalues[i].bname.deref();
        }
    }

    protected void write_debug(OutputStream outputStream, BHeader bHeader, LFunction lFunction) throws IOException {
        int n;
        bHeader.integer.write(outputStream, bHeader, new BInteger(lFunction.lines.length));
        for (n = 0; n < lFunction.lines.length; ++n) {
            bHeader.integer.write(outputStream, bHeader, new BInteger(lFunction.lines[n]));
        }
        bHeader.local.writeList(outputStream, bHeader, lFunction.locals);
        n = 0;
        for (LUpvalue lUpvalue : lFunction.upvalues) {
            if (lUpvalue.bname == null || lUpvalue.bname == LString.NULL) break;
            ++n;
        }
        bHeader.integer.write(outputStream, bHeader, new BInteger(n));
        for (int i = 0; i < n; ++i) {
            bHeader.string.write(outputStream, bHeader, lFunction.upvalues[i].bname);
        }
    }

    protected static class LFunctionParseState {
        public LString name;
        int lineBegin;
        int lineEnd;
        int lenUpvalues;
        int lenParameter;
        int vararg;
        int maximumStackSize;
        int length;
        int[] code;
        BList<LObject> constants;
        BList<LFunction> functions;
        BList<BInteger> lines;
        BList<LAbsLineInfo> abslineinfo;
        BList<LLocal> locals;
        LUpvalue[] upvalues;

        protected LFunctionParseState() {
        }
    }
}

