/*
 * Decompiled with CFR 0.152.
 */
package unluac.parse;

import unluac.decompile.PrintFlag;
import unluac.parse.LNumber;
import unluac.parse.LNumberType;

class LFloatNumber
extends LNumber {
    public static final int NAN_SHIFT_OFFSET = 29;
    public final float number;
    public final LNumberType.NumberMode mode;

    public LFloatNumber(float f, LNumberType.NumberMode numberMode) {
        this.number = f;
        this.mode = numberMode;
    }

    @Override
    public String toPrintString(int n) {
        if (this.mode == LNumberType.NumberMode.MODE_NUMBER && this.number == (float)Math.round(this.number)) {
            if (Float.floatToRawIntBits(this.number) == Float.floatToRawIntBits(-0.0f)) {
                return "-0";
            }
            return Integer.toString((int)this.number);
        }
        if (Float.isInfinite(this.number)) {
            return (double)this.number > 0.0 ? "1e9999" : "-1e9999";
        }
        if (Float.isNaN(this.number)) {
            if (PrintFlag.test(n, 1)) {
                int n2;
                int n3 = Float.floatToRawIntBits(this.number);
                if (n3 == (n2 = Float.floatToRawIntBits(Float.NaN))) {
                    return "NaN";
                }
                String string = "+";
                if (n3 < 0) {
                    n3 ^= Integer.MIN_VALUE;
                    string = "-";
                }
                long l = n3 ^ n2;
                return "NaN" + string + Long.toHexString(l << 29);
            }
            return "(0/0)";
        }
        return Float.toString(this.number);
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof LFloatNumber) {
            return Float.floatToRawIntBits(this.number) == Float.floatToRawIntBits(((LFloatNumber)object).number);
        }
        if (object instanceof LNumber) {
            return this.value() == ((LNumber)object).value();
        }
        return false;
    }

    @Override
    public double value() {
        return this.number;
    }

    @Override
    public boolean integralType() {
        return false;
    }

    @Override
    public long bits() {
        return Float.floatToRawIntBits(this.number);
    }
}

