/*
 * Decompiled with CFR 0.152.
 */
package unluac.parse;

import unluac.decompile.PrintFlag;
import unluac.parse.LNumber;
import unluac.parse.LNumberType;

class LDoubleNumber
extends LNumber {
    public final double number;
    public final LNumberType.NumberMode mode;

    public LDoubleNumber(double d, LNumberType.NumberMode numberMode) {
        this.number = d;
        this.mode = numberMode;
    }

    @Override
    public String toPrintString(int n) {
        if (this.mode == LNumberType.NumberMode.MODE_NUMBER && this.number == (double)Math.round(this.number)) {
            if (Double.doubleToRawLongBits(this.number) == Double.doubleToRawLongBits(-0.0)) {
                return "-0";
            }
            return Long.toString((long)this.number);
        }
        if (Double.isInfinite(this.number)) {
            return this.number > 0.0 ? "1e9999" : "-1e9999";
        }
        if (Double.isNaN(this.number)) {
            if (PrintFlag.test(n, 1)) {
                long l;
                long l2 = Double.doubleToRawLongBits(this.number);
                if (l2 == (l = Double.doubleToRawLongBits(Double.NaN))) {
                    return "NaN";
                }
                String string = "+";
                if (l2 < 0L) {
                    l2 ^= Long.MIN_VALUE;
                    string = "-";
                }
                return "NaN" + string + Long.toHexString(l2 ^ l);
            }
            return "(0/0)";
        }
        return Double.toString(this.number);
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof LDoubleNumber) {
            return Double.doubleToRawLongBits(this.number) == Double.doubleToRawLongBits(((LDoubleNumber)object).number);
        }
        if (object instanceof LNumber) {
            return this.value() == ((LNumber)object).value();
        }
        return false;
    }

    @Override
    public double value() {
        return this.number;
    }

    @Override
    public boolean integralType() {
        return false;
    }

    @Override
    public long bits() {
        return Double.doubleToRawLongBits(this.number);
    }
}

