/*
 * Decompiled with CFR 0.152.
 */
package unluac.parse;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import unluac.decompile.Type;
import unluac.parse.BHeader;
import unluac.parse.BObjectType;
import unluac.parse.LBoolean;
import unluac.parse.LNil;
import unluac.parse.LNumber;
import unluac.parse.LObject;
import unluac.parse.LString;

public class LConstantType
extends BObjectType<LObject> {
    @Override
    public LObject parse(ByteBuffer byteBuffer, BHeader bHeader) {
        int n = 0xFF & byteBuffer.get();
        Type type = bHeader.typemap.get(n);
        Objects.requireNonNull(bHeader);
        if (type == null) {
            throw new RuntimeException("unmapped type code " + n);
        }
        switch (type) {
            case NIL: {
                return LNil.NIL;
            }
            case BOOLEAN: {
                return bHeader.bool.parse(byteBuffer, bHeader);
            }
            case FALSE: {
                return LBoolean.LFALSE;
            }
            case TRUE: {
                return LBoolean.LTRUE;
            }
            case NUMBER: {
                return bHeader.number.parse(byteBuffer, bHeader);
            }
            case FLOAT: {
                return bHeader.lfloat.parse(byteBuffer, bHeader);
            }
            case INTEGER: {
                return bHeader.linteger.parse(byteBuffer, bHeader);
            }
            case STRING: 
            case SHORT_STRING: {
                return (LObject)bHeader.string.parse(byteBuffer, bHeader);
            }
            case LONG_STRING: {
                LString lString = (LString)bHeader.string.parse(byteBuffer, bHeader);
                lString.islong = true;
                return lString;
            }
        }
        throw new IllegalStateException();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void write(OutputStream outputStream, BHeader bHeader, LObject lObject) throws IOException {
        if (lObject instanceof LNil) {
            if (bHeader.typemap.NIL == -1) {
                throw new IllegalStateException();
            }
            outputStream.write(bHeader.typemap.NIL);
            return;
        } else if (lObject instanceof LBoolean) {
            LBoolean lBoolean = (LBoolean)lObject;
            boolean bl = lBoolean.value();
            if (bl && bHeader.typemap.TRUE != -1) {
                outputStream.write(bHeader.typemap.TRUE);
                return;
            } else if (!bl && bHeader.typemap.FALSE != -1) {
                outputStream.write(bHeader.typemap.FALSE);
                return;
            } else {
                if (bHeader.typemap.BOOLEAN == -1) throw new IllegalStateException();
                outputStream.write(bHeader.typemap.BOOLEAN);
                bHeader.bool.write(outputStream, bHeader, lBoolean);
            }
            return;
        } else if (lObject instanceof LNumber) {
            LNumber lNumber = (LNumber)lObject;
            if (bHeader.typemap.FLOAT != -1 && !lNumber.integralType()) {
                outputStream.write(bHeader.typemap.FLOAT);
                bHeader.lfloat.write(outputStream, bHeader, lNumber);
                return;
            } else if (bHeader.typemap.INTEGER != -1 && lNumber.integralType()) {
                outputStream.write(bHeader.typemap.INTEGER);
                bHeader.linteger.write(outputStream, bHeader, lNumber);
                return;
            } else {
                if (bHeader.typemap.NUMBER == -1) throw new IllegalStateException();
                outputStream.write(bHeader.typemap.NUMBER);
                bHeader.number.write(outputStream, bHeader, lNumber);
            }
            return;
        } else {
            if (!(lObject instanceof LString)) throw new IllegalStateException();
            LString lString = (LString)lObject;
            if (bHeader.typemap.SHORT_STRING != -1 && !lString.islong) {
                outputStream.write(bHeader.typemap.SHORT_STRING);
            } else if (bHeader.typemap.LONG_STRING != -1 && lString.islong) {
                outputStream.write(bHeader.typemap.LONG_STRING);
            } else if (bHeader.typemap.STRING != -1) {
                outputStream.write(bHeader.typemap.STRING);
            }
            bHeader.string.write(outputStream, bHeader, lString);
        }
    }
}

