/*
 * Decompiled with CFR 0.152.
 */
package unluac.parse;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import unluac.parse.BHeader;
import unluac.parse.BObjectType;
import unluac.parse.LBoolean;

public class LBooleanType
extends BObjectType<LBoolean> {
    @Override
    public LBoolean parse(ByteBuffer byteBuffer, BHeader bHeader) {
        byte by = byteBuffer.get();
        if ((by & 0xFFFFFFFE) != 0) {
            throw new IllegalStateException();
        }
        LBoolean lBoolean = by == 0 ? LBoolean.LFALSE : LBoolean.LTRUE;
        Objects.requireNonNull(bHeader);
        return lBoolean;
    }

    @Override
    public void write(OutputStream outputStream, BHeader bHeader, LBoolean lBoolean) throws IOException {
        int n = lBoolean.value() ? 1 : 0;
        outputStream.write(n);
    }
}

