/*
 * Decompiled with CFR 0.152.
 */
package unluac.parse;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import unluac.Version;
import unluac.parse.BHeader;
import unluac.parse.BInteger;
import unluac.parse.BList;
import unluac.parse.BObject;

public abstract class BObjectType<T extends BObject> {
    public abstract T parse(ByteBuffer var1, BHeader var2);

    public abstract void write(OutputStream var1, BHeader var2, T var3) throws IOException;

    public final BList<T> parseList(ByteBuffer byteBuffer, BHeader bHeader) {
        return this.parseList(byteBuffer, bHeader, Version.ListLengthMode.STRICT, null);
    }

    public final BList<T> parseList(ByteBuffer byteBuffer, BHeader bHeader, Version.ListLengthMode listLengthMode) {
        return this.parseList(byteBuffer, bHeader, listLengthMode, null);
    }

    public final BList<T> parseList(ByteBuffer byteBuffer, BHeader bHeader, Version.ListLengthMode listLengthMode, BInteger bInteger) {
        BInteger bInteger2 = (BInteger)bHeader.integer.parse(byteBuffer, bHeader);
        switch (listLengthMode) {
            case STRICT: {
                break;
            }
            case ALLOW_NEGATIVE: {
                if (bInteger2.signum() >= 0) break;
                bInteger2 = new BInteger(0);
                break;
            }
            case IGNORE: {
                if (bInteger == null) {
                    throw new IllegalStateException();
                }
                if (bInteger2.signum() == 0) break;
                bInteger2 = bInteger;
            }
        }
        return this.parseList(byteBuffer, bHeader, bInteger2);
    }

    public final BList<T> parseList(final ByteBuffer byteBuffer, final BHeader bHeader, BInteger bInteger) {
        final ArrayList arrayList = new ArrayList();
        bInteger.iterate(new Runnable(){

            @Override
            public void run() {
                arrayList.add(BObjectType.this.parse(byteBuffer, bHeader));
            }
        });
        return new BList(bInteger, arrayList);
    }

    public final void writeList(OutputStream outputStream, BHeader bHeader, T[] TArray) throws IOException {
        bHeader.integer.write(outputStream, bHeader, new BInteger(TArray.length));
        for (T t : TArray) {
            this.write(outputStream, bHeader, t);
        }
    }

    public final void writeList(OutputStream outputStream, BHeader bHeader, BList<T> bList) throws IOException {
        bHeader.integer.write(outputStream, bHeader, bList.length);
        Iterator<T> iterator = bList.iterator();
        while (iterator.hasNext()) {
            this.write(outputStream, bHeader, (BObject)iterator.next());
        }
    }
}

