/*
 * Decompiled with CFR 0.152.
 */
package unluac.parse;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import unluac.parse.BHeader;
import unluac.parse.BInteger;
import unluac.parse.BIntegerType;

class BIntegerType54
extends BIntegerType {
    @Override
    public BInteger parse(ByteBuffer byteBuffer, BHeader bHeader) {
        byte by;
        long l = 0L;
        do {
            by = byteBuffer.get();
            l = l << 7 | (long)(by & 0x7F);
        } while ((by & 0x80) == 0);
        if (Integer.MIN_VALUE <= l && l <= Integer.MAX_VALUE) {
            return new BInteger((int)l);
        }
        return new BInteger(BigInteger.valueOf(l));
    }

    @Override
    public void write(OutputStream outputStream, BHeader bHeader, BInteger bInteger) throws IOException {
        byte[] byArray = bInteger.compressedBytes();
        for (int i = byArray.length - 1; i >= 1; --i) {
            outputStream.write(byArray[i]);
        }
        outputStream.write(byArray[0] | 0x80);
    }
}

