/*
 * Decompiled with CFR 0.152.
 */
package unluac.parse;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Objects;
import unluac.parse.BHeader;
import unluac.parse.BInteger;
import unluac.parse.BIntegerType;
import unluac.parse.LHeader;

class BIntegerType50
extends BIntegerType {
    public final boolean signed;
    public final int intSize;
    public final boolean allownegative;

    public BIntegerType50(boolean bl, int n, boolean bl2) {
        this.signed = bl;
        this.intSize = n;
        this.allownegative = bl2;
    }

    protected BInteger raw_parse(ByteBuffer byteBuffer, BHeader bHeader) {
        BInteger bInteger;
        block10: {
            block9: {
                if (!this.signed || this.intSize != 0 && this.intSize != 1 && this.intSize != 2 && this.intSize != 4) break block9;
                switch (this.intSize) {
                    case 0: {
                        bInteger = new BInteger(0);
                        break block10;
                    }
                    case 1: {
                        bInteger = new BInteger(byteBuffer.get());
                        break block10;
                    }
                    case 2: {
                        bInteger = new BInteger(byteBuffer.getShort());
                        break block10;
                    }
                    case 4: {
                        bInteger = new BInteger(byteBuffer.getInt());
                        break block10;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
            byte[] byArray = new byte[this.intSize];
            int n = 0;
            int n2 = 1;
            if (byteBuffer.order() == ByteOrder.LITTLE_ENDIAN) {
                n = this.intSize - 1;
                n2 = -1;
            }
            for (int i = n; i >= 0 && i < this.intSize; i += n2) {
                byArray[i] = byteBuffer.get();
            }
            bInteger = this.signed ? new BInteger(new BigInteger(byArray)) : new BInteger(new BigInteger(1, byArray));
        }
        if (!this.allownegative && bInteger.signum() < 0) {
            throw new IllegalStateException("Illegal number");
        }
        return bInteger;
    }

    protected void raw_write(OutputStream outputStream, BHeader bHeader, BInteger bInteger) throws IOException {
        byte[] byArray = bInteger.littleEndianBytes(this.intSize);
        if (bHeader.lheader.endianness == LHeader.LEndianness.LITTLE) {
            for (byte by : byArray) {
                outputStream.write(by);
            }
        } else {
            for (int i = byArray.length - 1; i >= 0; --i) {
                outputStream.write(byArray[i]);
            }
        }
    }

    @Override
    public BInteger parse(ByteBuffer byteBuffer, BHeader bHeader) {
        BInteger bInteger = this.raw_parse(byteBuffer, bHeader);
        Objects.requireNonNull(bHeader);
        return bInteger;
    }

    @Override
    public void write(OutputStream outputStream, BHeader bHeader, BInteger bInteger) throws IOException {
        this.raw_write(outputStream, bHeader, bInteger);
    }

    @Override
    public int getSize() {
        return this.intSize;
    }
}

