/*
 * Decompiled with CFR 0.152.
 */
package unluac.parse;

import java.math.BigInteger;
import java.util.ArrayList;
import unluac.parse.BObject;

public class BInteger
extends BObject {
    private final BigInteger big;
    private final int n;
    private static BigInteger MAX_INT = null;
    private static BigInteger MIN_INT = null;

    public BInteger(BInteger bInteger) {
        this.big = bInteger.big;
        this.n = bInteger.n;
    }

    public BInteger(int n) {
        this.big = null;
        this.n = n;
    }

    public BInteger(BigInteger bigInteger) {
        this.big = bigInteger;
        this.n = 0;
        if (MAX_INT == null) {
            MAX_INT = BigInteger.valueOf(Integer.MAX_VALUE);
            MIN_INT = BigInteger.valueOf(Integer.MIN_VALUE);
        }
    }

    public int asInt() {
        if (this.big == null) {
            return this.n;
        }
        if (this.big.compareTo(MAX_INT) > 0 || this.big.compareTo(MIN_INT) < 0) {
            throw new IllegalStateException("The size of an integer is outside the range that unluac can handle.");
        }
        return this.big.intValue();
    }

    public int signum() {
        if (this.big == null) {
            if (this.n > 0) {
                return 1;
            }
            if (this.n < 0) {
                return -1;
            }
            if (this.n == 0) {
                return 0;
            }
            throw new IllegalStateException();
        }
        return this.big.signum();
    }

    public byte[] littleEndianBytes(int n) {
        int n2;
        Object object;
        ArrayList<Byte> arrayList = new ArrayList<Byte>();
        if (this.big == null) {
            if (n >= 1) {
                arrayList.add((byte)(this.n & 0xFF));
            }
            if (n >= 2) {
                arrayList.add((byte)(this.n >>> 8 & 0xFF));
            }
            if (n >= 3) {
                arrayList.add((byte)(this.n >>> 16 & 0xFF));
            }
            if (n >= 4) {
                arrayList.add((byte)(this.n >>> 24 & 0xFF));
            }
        } else {
            object = this.big;
            n2 = 0;
            if (((BigInteger)object).signum() < 0) {
                object = ((BigInteger)object).negate();
                object = ((BigInteger)object).subtract(BigInteger.ONE);
                n2 = 1;
            }
            BigInteger bigInteger = BigInteger.valueOf(256L);
            BigInteger bigInteger2 = BigInteger.valueOf(255L);
            while (((BigInteger)object).compareTo(bigInteger) < 0 && n > 0) {
                int n3 = ((BigInteger)object).and(bigInteger2).intValue();
                if (n2 != 0) {
                    n3 ^= 0xFFFFFFFF;
                }
                arrayList.add((byte)n3);
                object = ((BigInteger)object).divide(bigInteger);
                --n;
            }
        }
        while (n > arrayList.size()) {
            arrayList.add((byte)0);
        }
        object = new byte[arrayList.size()];
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            object[n2] = (Byte)arrayList.get(n2);
        }
        return object;
    }

    public byte[] compressedBytes() {
        BigInteger bigInteger = this.big;
        if (bigInteger == null) {
            bigInteger = BigInteger.valueOf(this.n);
        }
        if (bigInteger.compareTo(BigInteger.ZERO) == 0) {
            return new byte[]{0};
        }
        ArrayList<Byte> arrayList = new ArrayList<Byte>((bigInteger.bitCount() + 6) / 7);
        BigInteger bigInteger2 = BigInteger.valueOf(127L);
        while (bigInteger.compareTo(BigInteger.ZERO) > 0) {
            arrayList.add((byte)bigInteger.and(bigInteger2).intValue());
            bigInteger = bigInteger.shiftRight(7);
        }
        byte[] byArray = new byte[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            byArray[i] = (Byte)arrayList.get(i);
        }
        return byArray;
    }

    public void iterate(Runnable runnable) {
        if (this.big == null) {
            int n = this.n;
            if (n < 0) {
                throw new IllegalStateException("Illegal negative list length");
            }
            while (n-- != 0) {
                runnable.run();
            }
        } else {
            BigInteger bigInteger = this.big;
            if (bigInteger.signum() < 0) {
                throw new IllegalStateException("Illegal negative list length");
            }
            while (bigInteger.signum() > 0) {
                runnable.run();
                bigInteger = bigInteger.subtract(BigInteger.ONE);
            }
        }
    }
}

