/*
 * Decompiled with CFR 0.152.
 */
package unluac.parse;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.HashMap;
import unluac.Configuration;
import unluac.Version;
import unluac.assemble.Tokenizer;
import unluac.decompile.CodeExtract;
import unluac.decompile.OpcodeMap;
import unluac.decompile.Type;
import unluac.decompile.TypeMap;
import unluac.parse.BIntegerType;
import unluac.parse.LAbsLineInfoType;
import unluac.parse.LBooleanType;
import unluac.parse.LConstantType;
import unluac.parse.LFunction;
import unluac.parse.LFunctionType;
import unluac.parse.LHeader;
import unluac.parse.LHeaderType;
import unluac.parse.LLocalType;
import unluac.parse.LNumberType;
import unluac.parse.LStringType;
import unluac.parse.LUpvalueType;

public class BHeader {
    private static final byte[] signature = new byte[]{27, 76, 117, 97};
    public final boolean debug = false;
    public final Configuration config;
    public final Version version;
    public final LHeader lheader;
    public final LHeaderType lheader_type;
    public final BIntegerType integer;
    public final BIntegerType sizeT;
    public final LBooleanType bool;
    public final LNumberType number;
    public final LNumberType linteger;
    public final LNumberType lfloat;
    public final LStringType string;
    public final LConstantType constant;
    public final LAbsLineInfoType abslineinfo;
    public final LLocalType local;
    public final LUpvalueType upvalue;
    public final LFunctionType function;
    public final CodeExtract extractor;
    public final TypeMap typemap;
    public final OpcodeMap opmap;
    public final LFunction main;

    public BHeader(Version version, LHeader lHeader, TypeMap typeMap) {
        this(version, lHeader, typeMap, null);
    }

    public BHeader(Version version, LHeader lHeader, TypeMap typeMap, LFunction lFunction) {
        this.debug = false;
        this.config = null;
        this.version = version;
        this.lheader = lHeader;
        this.lheader_type = version.getLHeaderType();
        this.integer = lHeader.integer;
        this.sizeT = lHeader.sizeT;
        this.bool = lHeader.bool;
        this.number = lHeader.number;
        this.linteger = lHeader.linteger;
        this.lfloat = lHeader.lfloat;
        this.string = lHeader.string;
        this.constant = lHeader.constant;
        this.abslineinfo = lHeader.abslineinfo;
        this.local = lHeader.local;
        this.upvalue = lHeader.upvalue;
        this.function = lHeader.function;
        this.extractor = lHeader.extractor;
        this.typemap = typeMap;
        this.opmap = version.getOpcodeMap();
        this.main = lFunction;
    }

    public BHeader(ByteBuffer byteBuffer, Configuration configuration) {
        int n;
        block24: {
            this.debug = false;
            this.config = configuration;
            for (n = 0; n < signature.length; ++n) {
                if (byteBuffer.get() == signature[n]) continue;
                throw new IllegalStateException("The input file does not have the signature of a valid Lua file.");
            }
            n = 0xFF & byteBuffer.get();
            int n2 = n >> 4;
            int n3 = n & 0xF;
            this.version = Version.getVersion(configuration, n2, n3);
            if (this.version == null) {
                throw new IllegalStateException("The input chunk's Lua version is " + n2 + "." + n3 + "; unluac can only handle Lua 5.0 - Lua 5.4.");
            }
            this.lheader_type = this.version.getLHeaderType();
            this.lheader = this.lheader_type.parse(byteBuffer, this);
            this.integer = this.lheader.integer;
            this.sizeT = this.lheader.sizeT;
            this.bool = this.lheader.bool;
            this.number = this.lheader.number;
            this.linteger = this.lheader.linteger;
            this.lfloat = this.lheader.lfloat;
            this.string = this.lheader.string;
            this.constant = this.lheader.constant;
            this.abslineinfo = this.lheader.abslineinfo;
            this.local = this.lheader.local;
            this.upvalue = this.lheader.upvalue;
            this.function = this.lheader.function;
            this.extractor = this.lheader.extractor;
            try {
                Enum enum_;
                int n4;
                String string;
                HashMap<Integer, Type> hashMap;
                Tokenizer tokenizer;
                if (configuration.typemap != null) {
                    tokenizer = new Tokenizer(new FileInputStream(new File(configuration.typemap)));
                    hashMap = new HashMap<Integer, Type>();
                    while ((string = tokenizer.next()) != null) {
                        if (string.equals(".type")) {
                            string = tokenizer.next();
                            if (string == null) {
                                throw new RuntimeException("Unexpected end of typemap file.");
                            }
                            try {
                                n4 = Integer.parseInt(string);
                            }
                            catch (NumberFormatException numberFormatException) {
                                throw new RuntimeException("Excepted number in typemap file, got \"" + string + "\".");
                            }
                            string = tokenizer.next();
                            if (string == null) {
                                throw new RuntimeException("Unexpected end of typemap file.");
                            }
                            enum_ = Type.get(string);
                            if (enum_ == null) {
                                throw new RuntimeException("Unknown type name \"" + string + "\" in typemap file.");
                            }
                            hashMap.put(n4, (Type)enum_);
                            continue;
                        }
                        throw new RuntimeException("Unexpected token \"" + string + "\" + in typemap file.");
                    }
                    this.typemap = new TypeMap(hashMap);
                } else {
                    this.typemap = this.version.getTypeMap();
                }
                if (configuration.opmap != null) {
                    tokenizer = new Tokenizer(new FileInputStream(new File(configuration.opmap)));
                    hashMap = new HashMap();
                    while ((string = tokenizer.next()) != null) {
                        if (string.equals(".op")) {
                            string = tokenizer.next();
                            if (string == null) {
                                throw new RuntimeException("Unexpected end of opmap file.");
                            }
                            try {
                                n4 = Integer.parseInt(string);
                            }
                            catch (NumberFormatException numberFormatException) {
                                throw new RuntimeException("Excepted number in opmap file, got \"" + string + "\".");
                            }
                            string = tokenizer.next();
                            if (string == null) {
                                throw new RuntimeException("Unexpected end of opmap file.");
                            }
                            enum_ = this.version.getOpcodeMap().get(string);
                            if (enum_ == null) {
                                throw new RuntimeException("Unknown op name \"" + string + "\" in opmap file.");
                            }
                            hashMap.put(n4, (Type)enum_);
                            continue;
                        }
                        throw new RuntimeException("Unexpected token \"" + string + "\" + in opmap file.");
                    }
                    this.opmap = new OpcodeMap(hashMap);
                    break block24;
                }
                this.opmap = this.version.getOpcodeMap();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException.getMessage());
            }
        }
        int n5 = -1;
        if (n >= 83) {
            n5 = 0xFF & byteBuffer.get();
        }
        this.main = this.function.parse(byteBuffer, this);
        if (n5 >= 0 && this.main.numUpvalues != n5) {
            throw new IllegalStateException("The main chunk has the wrong number of upvalues: " + this.main.numUpvalues + " (" + n5 + " expected)");
        }
        if (this.main.numUpvalues >= 1 && n >= 82 && (this.main.upvalues[0].name == null || this.main.upvalues[0].name.isEmpty()) && configuration.mode == Configuration.Mode.DECOMPILE) {
            this.main.upvalues[0].name = "_ENV";
        }
        this.main.setLevel(1);
    }

    public void write(OutputStream outputStream) throws IOException {
        outputStream.write(signature);
        int n = this.version.getVersionMajor();
        int n2 = this.version.getVersionMinor();
        int n3 = n << 4 | n2;
        outputStream.write(n3);
        this.version.getLHeaderType().write(outputStream, this, this.lheader);
        if (this.version.useupvaluecountinheader.get().booleanValue()) {
            outputStream.write(this.main.numUpvalues);
        }
        this.function.write(outputStream, this, this.main);
    }
}

