/*
 * Decompiled with CFR 0.152.
 */
package unluac.decompile.target;

import unluac.decompile.Decompiler;
import unluac.decompile.Output;
import unluac.decompile.Walker;
import unluac.decompile.expression.Expression;
import unluac.decompile.expression.TableReference;
import unluac.decompile.target.Target;

public class TableTarget
extends Target {
    private final Expression table;
    private final Expression index;

    public TableTarget(Expression expression, Expression expression2) {
        this.table = expression;
        this.index = expression2;
    }

    @Override
    public void walk(Walker walker) {
        this.table.walk(walker);
        this.index.walk(walker);
    }

    @Override
    public void print(Decompiler decompiler, Output output, boolean bl) {
        new TableReference(this.table, this.index).print(decompiler, output);
    }

    @Override
    public void printMethod(Decompiler decompiler, Output output) {
        this.table.print(decompiler, output);
        output.print(":");
        output.print(this.index.asName());
    }

    @Override
    public boolean isFunctionName() {
        if (!this.index.isIdentifier()) {
            return false;
        }
        return this.table.isDotChain();
    }

    @Override
    public boolean beginsWithParen() {
        return this.table.isUngrouped() || this.table.beginsWithParen();
    }
}

