/*
 * Decompiled with CFR 0.152.
 */
package unluac.decompile.statement;

import java.util.List;
import unluac.decompile.Decompiler;
import unluac.decompile.Function;
import unluac.decompile.Output;
import unluac.decompile.Walker;

public abstract class Statement {
    public String comment;

    public static void printSequence(Decompiler decompiler, Output output, List<Statement> list) {
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            boolean bl = i + 1 == n;
            Statement statement = list.get(i);
            if (statement.beginsWithParen() && (i > 0 || decompiler.getVersion().allowpreceedingsemicolon.get().booleanValue())) {
                output.print(";");
            }
            if (bl) {
                statement.printTail(decompiler, output);
            } else {
                statement.print(decompiler, output);
            }
            if (statement.suppressNewline()) continue;
            output.println();
        }
    }

    public abstract void print(Decompiler var1, Output var2);

    public void printTail(Decompiler decompiler, Output output) {
        this.print(decompiler, output);
    }

    public void addComment(String string) {
        this.comment = string;
    }

    public abstract void walk(Walker var1);

    public boolean beginsWithParen() {
        return false;
    }

    public boolean suppressNewline() {
        return false;
    }

    public boolean useConstant(Function function, int n) {
        return false;
    }
}

