/*
 * Decompiled with CFR 0.152.
 */
package unluac.decompile.statement;

import java.util.ArrayList;
import unluac.decompile.Decompiler;
import unluac.decompile.Output;
import unluac.decompile.Walker;
import unluac.decompile.expression.Expression;
import unluac.decompile.statement.Statement;

public class Return
extends Statement {
    private Expression[] values;

    public Return() {
        this.values = new Expression[0];
    }

    public Return(Expression expression) {
        this.values = new Expression[1];
        this.values[0] = expression;
    }

    public Return(Expression[] expressionArray) {
        this.values = expressionArray;
    }

    @Override
    public void walk(Walker walker) {
        walker.visitStatement(this);
        for (Expression expression : this.values) {
            expression.walk(walker);
        }
    }

    @Override
    public void print(Decompiler decompiler, Output output) {
        output.print("do ");
        this.printTail(decompiler, output);
        output.print(" end");
    }

    @Override
    public void printTail(Decompiler decompiler, Output output) {
        output.print("return");
        if (this.values.length > 0) {
            output.print(" ");
            ArrayList<Expression> arrayList = new ArrayList<Expression>(this.values.length);
            for (Expression expression : this.values) {
                arrayList.add(expression);
            }
            Expression.printSequence(decompiler, output, arrayList, false, true);
        }
    }
}

