/*
 * Decompiled with CFR 0.152.
 */
package unluac.decompile.statement;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import unluac.decompile.Declaration;
import unluac.decompile.Decompiler;
import unluac.decompile.Output;
import unluac.decompile.Walker;
import unluac.decompile.expression.Expression;
import unluac.decompile.statement.Statement;
import unluac.decompile.target.Target;

public class Assignment
extends Statement {
    private final ArrayList<Target> targets = new ArrayList(5);
    private final ArrayList<Expression> values = new ArrayList(5);
    private final ArrayList<Integer> lines = new ArrayList(5);
    private boolean allnil = true;
    private boolean declare = false;
    private int declareStart = 0;
    private int register = -1;

    public Assignment() {
    }

    @Override
    public void walk(Walker walker) {
        walker.visitStatement(this);
        for (Target object : this.targets) {
            object.walk(walker);
        }
        for (Expression expression : this.values) {
            expression.walk(walker);
        }
    }

    @Override
    public boolean beginsWithParen() {
        return !this.declare && this.targets.get(0).beginsWithParen();
    }

    public Target getFirstTarget() {
        return this.targets.get(0);
    }

    public Target getLastTarget() {
        return this.targets.get(this.targets.size() - 1);
    }

    public Expression getFirstValue() {
        return this.values.get(0);
    }

    public void replaceLastValue(Expression expression) {
        this.values.set(this.values.size() - 1, expression);
    }

    public int getFirstLine() {
        return this.lines.get(0);
    }

    public boolean assignsTarget(Declaration declaration) {
        for (Target target : this.targets) {
            if (!target.isDeclaration(declaration)) continue;
            return true;
        }
        return false;
    }

    public int getArity() {
        return this.targets.size();
    }

    public Assignment(Target target, Expression expression, int n) {
        this.targets.add(target);
        this.values.add(expression);
        this.lines.add(n);
        this.allnil = this.allnil && expression.isNil();
    }

    public void addFirst(Target target, Expression expression, int n) {
        this.targets.add(0, target);
        this.values.add(0, expression);
        this.lines.add(0, n);
        this.allnil = this.allnil && expression.isNil();
    }

    public void addLast(Target target, Expression expression, int n) {
        int n2;
        if (this.targets.contains(target)) {
            n2 = this.targets.indexOf(target);
            this.targets.remove(n2);
            expression = this.values.remove(n2);
            this.lines.remove(n2);
        }
        n2 = this.targets.size();
        this.targets.add(target);
        this.values.add(n2, expression);
        this.lines.add(n2, n);
        this.allnil = this.allnil && expression.isNil();
    }

    public boolean hasExcess() {
        return this.values.size() > this.targets.size();
    }

    public void addExcessValue(Expression expression, int n, int n2) {
        this.values.add(expression);
        this.lines.add(n);
        this.allnil = false;
        int n3 = n2 - (this.values.size() - 1);
        if (this.register != -1 && this.register != n3) {
            throw new IllegalStateException();
        }
        this.register = n3;
    }

    public int getRegister(int n) {
        if (n < 0 || n >= this.values.size()) {
            throw new IndexOutOfBoundsException();
        }
        if (this.register == -1) {
            throw new IllegalStateException();
        }
        return this.register + n;
    }

    public int getLastRegister() {
        return this.getRegister(this.values.size() - 1);
    }

    public Expression getValue(int n) {
        int n2 = 0;
        for (Target target : this.targets) {
            if (target.isLocal() && target.getIndex() == n) {
                return this.values.get(n2);
            }
            ++n2;
        }
        throw new IllegalStateException();
    }

    public void replaceValue(int n, Expression expression) {
        int n2 = 0;
        for (Target target : this.targets) {
            if (target.isLocal() && target.getIndex() == n) {
                this.values.set(n2, expression);
                return;
            }
            ++n2;
        }
        throw new IllegalStateException();
    }

    public boolean assignListEquals(List<Declaration> list) {
        if (list.size() != this.targets.size()) {
            return false;
        }
        for (Target target : this.targets) {
            boolean bl = false;
            for (Declaration declaration : list) {
                if (!target.isDeclaration(declaration)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    public void declare(int n) {
        this.declare = true;
        this.declareStart = n;
    }

    public boolean isDeclaration() {
        return this.declare;
    }

    public boolean assigns(Declaration declaration) {
        for (Target target : this.targets) {
            if (!target.isDeclaration(declaration)) continue;
            return true;
        }
        return false;
    }

    public boolean canDeclare(List<Declaration> list) {
        for (Target target : this.targets) {
            boolean bl = false;
            for (Declaration declaration : list) {
                if (!target.isDeclaration(declaration)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    @Override
    public void print(Decompiler decompiler, Output output) {
        if (!this.targets.isEmpty()) {
            boolean bl = false;
            if (this.targets.size() == 1 && this.values.size() == 1 && this.values.get(0).isClosure() && this.targets.get(0).isFunctionName()) {
                Expression expression = this.values.get(0);
                if (!this.declare || this.declareStart >= expression.closureUpvalueLine()) {
                    bl = true;
                }
                if (this.targets.get(0).isLocal() && expression.isUpvalueOf(this.targets.get(0).getIndex())) {
                    bl = true;
                }
            }
            if (bl) {
                output.paragraph();
            }
            if (this.declare) {
                output.print("local ");
            }
            if (!bl) {
                this.targets.get(0).print(decompiler, output, this.declare);
                for (int i = 1; i < this.targets.size(); ++i) {
                    output.print(", ");
                    this.targets.get(i).print(decompiler, output, this.declare);
                }
                if (!this.declare || !this.allnil) {
                    output.print(" = ");
                    LinkedList<Expression> linkedList = new LinkedList<Expression>();
                    int n = this.values.size();
                    if (n >= 2 && this.values.get(n - 1).isNil() && (this.lines.get(n - 1).intValue() == this.values.get(n - 1).getConstantLine() || this.values.get(n - 1).getConstantLine() == -1)) {
                        linkedList.addAll(this.values);
                    } else {
                        boolean bl2 = false;
                        for (int i = n - 1; i >= 0; --i) {
                            Expression expression = this.values.get(i);
                            if (bl2 || !expression.isNil() || expression.getConstantIndex() != -1) {
                                bl2 = true;
                            }
                            if (!bl2) continue;
                            linkedList.addFirst(expression);
                        }
                        if (linkedList.isEmpty() && !this.declare) {
                            linkedList.addAll(this.values);
                        }
                    }
                    Expression.printSequence(decompiler, output, linkedList, false, this.targets.size() > linkedList.size());
                }
            } else {
                this.values.get(0).printClosure(decompiler, output, this.targets.get(0));
                output.paragraph();
            }
            if (this.comment != null) {
                output.print(" -- ");
                output.print(this.comment);
            }
        }
    }
}

