/*
 * Decompiled with CFR 0.152.
 */
package unluac.decompile.operation;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import unluac.decompile.Registers;
import unluac.decompile.block.Block;
import unluac.decompile.expression.Expression;
import unluac.decompile.operation.Operation;
import unluac.decompile.statement.Assignment;
import unluac.decompile.statement.Statement;

public class MultipleRegisterSet
extends Operation {
    public final int registerFirst;
    public final int registerLast;
    public final Expression value;

    public MultipleRegisterSet(int n, int n2, int n3, Expression expression) {
        super(n);
        this.registerFirst = n2;
        this.registerLast = n3;
        this.value = expression;
    }

    @Override
    public List<Statement> process(Registers registers, Block block) {
        int n = 0;
        Assignment assignment = new Assignment();
        for (int i = this.registerFirst; i <= this.registerLast; ++i) {
            registers.setValue(i, this.line, this.value);
            if (!registers.isAssignable(i, this.line)) continue;
            assignment.addLast(registers.getTarget(i, this.line), this.value, this.line);
            ++n;
        }
        if (n > 0) {
            return Arrays.asList(assignment);
        }
        return Collections.emptyList();
    }
}

