/*
 * Decompiled with CFR 0.152.
 */
package unluac.decompile.expression;

import unluac.decompile.Decompiler;
import unluac.decompile.Output;
import unluac.decompile.Walker;
import unluac.decompile.expression.Expression;

public class UnaryExpression
extends Expression {
    private final String op;
    private final Expression expression;

    public UnaryExpression(String string, Expression expression, int n) {
        super(n);
        this.op = string;
        this.expression = expression;
    }

    @Override
    public void walk(Walker walker) {
        walker.visitExpression(this);
        this.expression.walk(walker);
    }

    @Override
    public boolean isUngrouped() {
        return true;
    }

    @Override
    public int getConstantIndex() {
        return this.expression.getConstantIndex();
    }

    @Override
    public void print(Decompiler decompiler, Output output) {
        output.print(this.op);
        if (this.precedence > this.expression.precedence) {
            output.print("(");
        }
        this.expression.print(decompiler, output);
        if (this.precedence > this.expression.precedence) {
            output.print(")");
        }
    }
}

