/*
 * Decompiled with CFR 0.152.
 */
package unluac.decompile.expression;

import unluac.decompile.Decompiler;
import unluac.decompile.Output;
import unluac.decompile.Walker;
import unluac.decompile.expression.Expression;

public class TableReference
extends Expression {
    private final Expression table;
    private final Expression index;

    public TableReference(Expression expression, Expression expression2) {
        super(13);
        this.table = expression;
        this.index = expression2;
    }

    @Override
    public void walk(Walker walker) {
        walker.visitExpression(this);
        this.table.walk(walker);
        this.index.walk(walker);
    }

    @Override
    public int getConstantIndex() {
        return Math.max(this.table.getConstantIndex(), this.index.getConstantIndex());
    }

    @Override
    public void print(Decompiler decompiler, Output output) {
        boolean bl;
        boolean bl2 = bl = this.table.isEnvironmentTable(decompiler) && this.index.isIdentifier();
        if (!bl) {
            if (this.table.isUngrouped()) {
                output.print("(");
                this.table.print(decompiler, output);
                output.print(")");
            } else {
                this.table.print(decompiler, output);
            }
        }
        if (this.index.isIdentifier()) {
            if (!bl) {
                output.print(".");
            }
            output.print(this.index.asName());
        } else {
            output.print("[");
            this.index.printBraced(decompiler, output);
            output.print("]");
        }
    }

    @Override
    public boolean isDotChain() {
        return this.index.isIdentifier() && this.table.isDotChain();
    }

    @Override
    public boolean isMemberAccess() {
        return this.index.isIdentifier();
    }

    @Override
    public boolean beginsWithParen() {
        return this.table.isUngrouped() || this.table.beginsWithParen();
    }

    @Override
    public Expression getTable() {
        return this.table;
    }

    @Override
    public String getField() {
        return this.index.asName();
    }
}

