/*
 * Decompiled with CFR 0.152.
 */
package unluac.decompile.expression;

import java.util.ArrayList;
import java.util.Collections;
import unluac.decompile.Decompiler;
import unluac.decompile.Output;
import unluac.decompile.Walker;
import unluac.decompile.expression.Expression;

public class TableLiteral
extends Expression {
    private ArrayList<Entry> entries;
    private boolean isObject = true;
    private boolean isList = true;
    private int listLength = 1;
    private final int hashSize;
    private int hashCount;

    public TableLiteral(int n, int n2) {
        super(13);
        this.entries = new ArrayList(n + n2);
        this.hashSize = n2;
        this.hashCount = 0;
    }

    @Override
    public void walk(Walker walker) {
        Collections.sort(this.entries);
        walker.visitExpression(this);
        boolean bl = false;
        for (Entry entry : this.entries) {
            entry.key.walk(walker);
            if (bl) continue;
            entry.value.walk(walker);
            if (!entry.value.isMultiple()) continue;
            bl = true;
        }
    }

    @Override
    public int getConstantIndex() {
        int n = -1;
        for (Entry entry : this.entries) {
            n = Math.max(entry.key.getConstantIndex(), n);
            n = Math.max(entry.value.getConstantIndex(), n);
        }
        return n;
    }

    @Override
    public void print(Decompiler decompiler, Output output) {
        this.listLength = 1;
        if (this.entries.isEmpty()) {
            output.print("{}");
        } else {
            boolean bl;
            boolean bl2 = bl = this.isList && this.entries.size() > 5 || this.isObject && this.entries.size() > 2 || !this.isObject;
            if (!bl) {
                for (Entry entry : this.entries) {
                    Expression expression = entry.value;
                    if (expression.isBrief()) continue;
                    bl = true;
                    break;
                }
            }
            output.print("{");
            if (bl) {
                output.println();
                output.indent();
            }
            this.printEntry(decompiler, 0, output);
            if (!this.entries.get((int)0).value.isMultiple()) {
                for (int i = 1; i < this.entries.size(); ++i) {
                    output.print(",");
                    if (bl) {
                        output.println();
                    } else {
                        output.print(" ");
                    }
                    this.printEntry(decompiler, i, output);
                    if (this.entries.get((int)i).value.isMultiple()) break;
                }
            }
            if (bl) {
                output.println();
                output.dedent();
            }
            output.print("}");
        }
    }

    private void printEntry(Decompiler decompiler, int n, Output output) {
        boolean bl;
        Entry entry = this.entries.get(n);
        Expression expression = entry.key;
        Expression expression2 = entry.value;
        boolean bl2 = entry.isList;
        boolean bl3 = bl = n + 1 >= this.entries.size() || expression2.isMultiple();
        if (bl2 && expression.isInteger() && this.listLength == expression.asInteger()) {
            if (bl) {
                expression2.printMultiple(decompiler, output);
            } else {
                expression2.print(decompiler, output);
            }
            ++this.listLength;
        } else if (entry.hash) {
            output.print(expression.asName());
            output.print(" = ");
            expression2.print(decompiler, output);
        } else {
            output.print("[");
            expression.printBraced(decompiler, output);
            output.print("] = ");
            expression2.print(decompiler, output);
        }
    }

    @Override
    public boolean isTableLiteral() {
        return true;
    }

    @Override
    public boolean isUngrouped() {
        return true;
    }

    @Override
    public boolean isNewEntryAllowed() {
        return true;
    }

    @Override
    public void addEntry(Entry entry) {
        if (this.hashCount < this.hashSize && entry.key.isIdentifier()) {
            entry.hash = true;
            ++this.hashCount;
        }
        this.entries.add(entry);
        this.isObject = this.isObject && (entry.isList || entry.key.isIdentifier());
        this.isList = this.isList && entry.isList;
    }

    @Override
    public boolean isBrief() {
        return false;
    }

    public static class Entry
    implements Comparable<Entry> {
        public final Expression key;
        public final Expression value;
        public final boolean isList;
        public final int timestamp;
        private boolean hash;

        public Entry(Expression expression, Expression expression2, boolean bl, int n) {
            this.key = expression;
            this.value = expression2;
            this.isList = bl;
            this.timestamp = n;
        }

        @Override
        public int compareTo(Entry entry) {
            return Integer.valueOf(this.timestamp).compareTo(entry.timestamp);
        }
    }
}

