/*
 * Decompiled with CFR 0.152.
 */
package unluac.decompile.expression;

import java.util.ArrayList;
import unluac.decompile.Decompiler;
import unluac.decompile.Output;
import unluac.decompile.Walker;
import unluac.decompile.expression.Expression;

public class FunctionCall
extends Expression {
    private final Expression function;
    private final Expression[] arguments;
    private final boolean multiple;

    public FunctionCall(Expression expression, Expression[] expressionArray, boolean bl) {
        super(13);
        this.function = expression;
        this.arguments = expressionArray;
        this.multiple = bl;
    }

    @Override
    public void walk(Walker walker) {
        walker.visitExpression(this);
        this.function.walk(walker);
        for (Expression expression : this.arguments) {
            expression.walk(walker);
        }
    }

    @Override
    public int getConstantIndex() {
        int n = this.function.getConstantIndex();
        for (Expression expression : this.arguments) {
            n = Math.max(expression.getConstantIndex(), n);
        }
        return n;
    }

    @Override
    public boolean isMultiple() {
        return this.multiple;
    }

    @Override
    public void printMultiple(Decompiler decompiler, Output output) {
        if (!this.multiple) {
            output.print("(");
        }
        this.print(decompiler, output);
        if (!this.multiple) {
            output.print(")");
        }
    }

    private boolean isMethodCall() {
        return this.function.isMemberAccess() && this.arguments.length > 0 && this.function.getTable() == this.arguments[0];
    }

    @Override
    public boolean beginsWithParen() {
        if (this.isMethodCall()) {
            Expression expression = this.function.getTable();
            return expression.isUngrouped() || expression.beginsWithParen();
        }
        return this.function.isUngrouped() || this.function.beginsWithParen();
    }

    @Override
    public void print(Decompiler decompiler, Output output) {
        ArrayList<Expression> arrayList = new ArrayList<Expression>(this.arguments.length);
        if (this.isMethodCall()) {
            Expression expression = this.function.getTable();
            if (expression.isUngrouped()) {
                output.print("(");
                expression.print(decompiler, output);
                output.print(")");
            } else {
                expression.print(decompiler, output);
            }
            output.print(":");
            output.print(this.function.getField());
            for (int i = 1; i < this.arguments.length; ++i) {
                arrayList.add(this.arguments[i]);
            }
        } else {
            if (this.function.isUngrouped()) {
                output.print("(");
                this.function.print(decompiler, output);
                output.print(")");
            } else {
                this.function.print(decompiler, output);
            }
            for (int i = 0; i < this.arguments.length; ++i) {
                arrayList.add(this.arguments[i]);
            }
        }
        output.print("(");
        Expression.printSequence(decompiler, output, arrayList, false, true);
        output.print(")");
    }
}

