/*
 * Decompiled with CFR 0.152.
 */
package unluac.decompile.expression;

import java.util.List;
import unluac.decompile.Decompiler;
import unluac.decompile.Output;
import unluac.decompile.Walker;
import unluac.decompile.expression.BinaryExpression;
import unluac.decompile.expression.TableLiteral;
import unluac.decompile.expression.UnaryExpression;
import unluac.decompile.target.Target;

public abstract class Expression {
    public static final int PRECEDENCE_OR = 1;
    public static final int PRECEDENCE_AND = 2;
    public static final int PRECEDENCE_COMPARE = 3;
    public static final int PRECEDENCE_BOR = 4;
    public static final int PRECEDENCE_BXOR = 5;
    public static final int PRECEDENCE_BAND = 6;
    public static final int PRECEDENCE_SHIFT = 7;
    public static final int PRECEDENCE_CONCAT = 8;
    public static final int PRECEDENCE_ADD = 9;
    public static final int PRECEDENCE_MUL = 10;
    public static final int PRECEDENCE_UNARY = 11;
    public static final int PRECEDENCE_POW = 12;
    public static final int PRECEDENCE_ATOMIC = 13;
    public static final int ASSOCIATIVITY_NONE = 0;
    public static final int ASSOCIATIVITY_LEFT = 1;
    public static final int ASSOCIATIVITY_RIGHT = 2;
    public final int precedence;

    public static BinaryExpression make(BinaryOperation binaryOperation, Expression expression, Expression expression2) {
        return Expression.make(binaryOperation, expression, expression2, false);
    }

    public static BinaryExpression make(BinaryOperation binaryOperation, Expression expression, Expression expression2, boolean bl) {
        if (bl) {
            Expression expression3 = expression;
            expression = expression2;
            expression2 = expression3;
        }
        return new BinaryExpression(binaryOperation.op, expression, expression2, binaryOperation.precedence, binaryOperation.associativity);
    }

    public static UnaryExpression make(UnaryOperation unaryOperation, Expression expression) {
        return new UnaryExpression(unaryOperation.op, expression, 11);
    }

    public static void printSequence(Decompiler decompiler, Output output, List<Expression> list, boolean bl, boolean bl2) {
        int n = list.size();
        int n2 = 1;
        for (Expression expression : list) {
            boolean bl3;
            boolean bl4 = bl3 = n2 == n;
            if (expression.isMultiple()) {
                bl3 = true;
            }
            if (bl3) {
                if (bl2) {
                    expression.printMultiple(decompiler, output);
                    break;
                }
                expression.print(decompiler, output);
                break;
            }
            expression.print(decompiler, output);
            output.print(",");
            if (bl) {
                output.println();
            } else {
                output.print(" ");
            }
            ++n2;
        }
    }

    public Expression(int n) {
        this.precedence = n;
    }

    protected static void printUnary(Decompiler decompiler, Output output, String string, Expression expression) {
        output.print(string);
        expression.print(decompiler, output);
    }

    protected static void printBinary(Decompiler decompiler, Output output, String string, Expression expression, Expression expression2) {
        expression.print(decompiler, output);
        output.print(" ");
        output.print(string);
        output.print(" ");
        expression2.print(decompiler, output);
    }

    public abstract void walk(Walker var1);

    public abstract void print(Decompiler var1, Output var2);

    public void printBraced(Decompiler decompiler, Output output) {
        this.print(decompiler, output);
    }

    public void printMultiple(Decompiler decompiler, Output output) {
        this.print(decompiler, output);
    }

    public abstract int getConstantIndex();

    public int getConstantLine() {
        return -1;
    }

    public boolean beginsWithParen() {
        return false;
    }

    public boolean isNil() {
        return false;
    }

    public boolean isClosure() {
        return false;
    }

    public boolean isConstant() {
        return false;
    }

    public boolean isUngrouped() {
        return false;
    }

    public boolean isUpvalueOf(int n) {
        throw new IllegalStateException();
    }

    public boolean isBoolean() {
        return false;
    }

    public boolean isInteger() {
        return false;
    }

    public int asInteger() {
        throw new IllegalStateException();
    }

    public boolean isString() {
        return false;
    }

    public boolean isIdentifier() {
        return false;
    }

    public boolean isDotChain() {
        return false;
    }

    public int closureUpvalueLine() {
        throw new IllegalStateException();
    }

    public void printClosure(Decompiler decompiler, Output output, Target target) {
        throw new IllegalStateException();
    }

    public String asName() {
        throw new IllegalStateException();
    }

    public boolean isTableLiteral() {
        return false;
    }

    public boolean isNewEntryAllowed() {
        throw new IllegalStateException();
    }

    public void addEntry(TableLiteral.Entry entry) {
        throw new IllegalStateException();
    }

    public boolean isMultiple() {
        return false;
    }

    public boolean isMemberAccess() {
        return false;
    }

    public Expression getTable() {
        throw new IllegalStateException();
    }

    public String getField() {
        throw new IllegalStateException();
    }

    public boolean isBrief() {
        return false;
    }

    public boolean isEnvironmentTable(Decompiler decompiler) {
        return false;
    }

    public static enum BinaryOperation {
        CONCAT("..", 8, 2),
        ADD("+", 9, 1),
        SUB("-", 9, 1),
        MUL("*", 10, 1),
        DIV("/", 10, 1),
        IDIV("//", 10, 1),
        MOD("%", 10, 1),
        POW("^", 12, 2),
        BAND("&", 6, 1),
        BOR("|", 4, 1),
        BXOR("~", 5, 1),
        SHL("<<", 7, 1),
        SHR(">>", 7, 1),
        OR("or", 1, 0),
        AND("and", 2, 0);

        public final String op;
        public final int precedence;
        public final int associativity;

        private BinaryOperation(String string2, int n2, int n3) {
            this.op = string2;
            this.precedence = n2;
            this.associativity = n3;
        }
    }

    public static enum UnaryOperation {
        UNM("-"),
        NOT("not "),
        LEN("#"),
        BNOT("~");

        public final String op;

        private UnaryOperation(String string2) {
            this.op = string2;
        }
    }
}

