/*
 * Decompiled with CFR 0.152.
 */
package unluac.decompile.expression;

import unluac.decompile.Decompiler;
import unluac.decompile.Output;
import unluac.decompile.Walker;
import unluac.decompile.expression.Expression;
import unluac.decompile.target.TableTarget;
import unluac.decompile.target.Target;
import unluac.decompile.target.VariableTarget;
import unluac.parse.LFunction;
import unluac.parse.LUpvalue;

public class ClosureExpression
extends Expression {
    private final LFunction function;
    private int upvalueLine;

    public ClosureExpression(LFunction lFunction, int n) {
        super(13);
        this.function = lFunction;
        this.upvalueLine = n;
    }

    @Override
    public void walk(Walker walker) {
        walker.visitExpression(this);
    }

    @Override
    public int getConstantIndex() {
        return -1;
    }

    @Override
    public boolean isClosure() {
        return true;
    }

    @Override
    public boolean isUngrouped() {
        return true;
    }

    @Override
    public boolean isUpvalueOf(int n) {
        for (int i = 0; i < this.function.upvalues.length; ++i) {
            LUpvalue lUpvalue = this.function.upvalues[i];
            if (!lUpvalue.instack || lUpvalue.idx != n) continue;
            return true;
        }
        return false;
    }

    @Override
    public int closureUpvalueLine() {
        return this.upvalueLine;
    }

    @Override
    public void print(Decompiler decompiler, Output output) {
        Decompiler decompiler2 = new Decompiler(this.function, decompiler.declList, this.upvalueLine);
        output.print("function");
        this.printMain(output, decompiler2, true);
    }

    @Override
    public void printClosure(Decompiler decompiler, Output output, Target target) {
        Decompiler decompiler2 = new Decompiler(this.function, decompiler.declList, this.upvalueLine);
        output.print("function ");
        if (this.function.numParams >= 1 && decompiler2.declList[0].name.equals("self") && target instanceof TableTarget) {
            target.printMethod(decompiler, output);
            this.printMain(output, decompiler2, false);
        } else {
            target.print(decompiler, output, false);
            this.printMain(output, decompiler2, true);
        }
    }

    private void printMain(Output output, Decompiler decompiler, boolean bl) {
        int n;
        output.print("(");
        int n2 = n = bl ? 0 : 1;
        if (this.function.numParams > n) {
            new VariableTarget(decompiler.declList[n]).print(decompiler, output, false);
            for (int i = n + 1; i < this.function.numParams; ++i) {
                output.print(", ");
                new VariableTarget(decompiler.declList[i]).print(decompiler, output, false);
            }
        }
        if (this.function.vararg != 0) {
            if (this.function.numParams > n) {
                output.print(", ...");
            } else {
                output.print("...");
            }
        }
        output.print(")");
        output.println();
        output.indent();
        Decompiler.State state = decompiler.decompile();
        decompiler.print(state, output);
        output.dedent();
        output.print("end");
    }
}

