/*
 * Decompiled with CFR 0.152.
 */
package unluac.decompile.expression;

import unluac.decompile.Decompiler;
import unluac.decompile.Output;
import unluac.decompile.Walker;
import unluac.decompile.expression.Expression;

public class BinaryExpression
extends Expression {
    private final String op;
    private final Expression left;
    private final Expression right;
    private final int associativity;

    public static BinaryExpression replaceRight(BinaryExpression binaryExpression, Expression expression) {
        return new BinaryExpression(binaryExpression.op, binaryExpression.left, expression, binaryExpression.precedence, binaryExpression.associativity);
    }

    public BinaryExpression(String string, Expression expression, Expression expression2, int n, int n2) {
        super(n);
        this.op = string;
        this.left = expression;
        this.right = expression2;
        this.associativity = n2;
    }

    @Override
    public void walk(Walker walker) {
        walker.visitExpression(this);
        this.left.walk(walker);
        this.right.walk(walker);
    }

    @Override
    public boolean isUngrouped() {
        return !this.beginsWithParen();
    }

    @Override
    public int getConstantIndex() {
        return Math.max(this.left.getConstantIndex(), this.right.getConstantIndex());
    }

    @Override
    public boolean beginsWithParen() {
        return this.leftGroup() || this.left.beginsWithParen();
    }

    @Override
    public void print(Decompiler decompiler, Output output) {
        boolean bl = this.leftGroup();
        boolean bl2 = this.rightGroup();
        if (bl) {
            output.print("(");
        }
        this.left.print(decompiler, output);
        if (bl) {
            output.print(")");
        }
        output.print(" ");
        output.print(this.op);
        output.print(" ");
        if (bl2) {
            output.print("(");
        }
        this.right.print(decompiler, output);
        if (bl2) {
            output.print(")");
        }
    }

    public String getOp() {
        return this.op;
    }

    private boolean leftGroup() {
        return this.precedence > this.left.precedence || this.precedence == this.left.precedence && this.associativity == 2;
    }

    private boolean rightGroup() {
        return this.precedence > this.right.precedence || this.precedence == this.right.precedence && this.associativity == 1;
    }
}

