/*
 * Decompiled with CFR 0.152.
 */
package unluac.decompile.condition;

import unluac.decompile.Registers;
import unluac.decompile.condition.AndCondition;
import unluac.decompile.condition.Condition;
import unluac.decompile.condition.NotCondition;
import unluac.decompile.expression.BinaryExpression;
import unluac.decompile.expression.Expression;

public class OrCondition
implements Condition {
    private Condition left;
    private Condition right;

    public OrCondition(Condition condition, Condition condition2) {
        this.left = condition;
        this.right = condition2;
    }

    @Override
    public Condition inverse() {
        if (this.invertible()) {
            return new AndCondition(this.left.inverse(), this.right.inverse());
        }
        return new NotCondition(this);
    }

    @Override
    public boolean invertible() {
        return this.right.invertible();
    }

    @Override
    public int register() {
        return this.right.register();
    }

    @Override
    public boolean isRegisterTest() {
        return false;
    }

    @Override
    public boolean isOrCondition() {
        return true;
    }

    @Override
    public boolean isSplitable() {
        return false;
    }

    @Override
    public Condition[] split() {
        throw new IllegalStateException();
    }

    @Override
    public Expression asExpression(Registers registers) {
        return new BinaryExpression("or", this.left.asExpression(registers), this.right.asExpression(registers), 1, 0);
    }

    @Override
    public String toString() {
        return "(" + String.valueOf(this.left) + " or " + String.valueOf(this.right) + ")";
    }
}

