/*
 * Decompiled with CFR 0.152.
 */
package unluac.decompile.condition;

import unluac.decompile.Registers;
import unluac.decompile.expression.ConstantExpression;
import unluac.decompile.expression.Expression;

public interface Condition {
    public Condition inverse();

    public boolean invertible();

    public int register();

    public boolean isRegisterTest();

    public boolean isOrCondition();

    public boolean isSplitable();

    public Condition[] split();

    public Expression asExpression(Registers var1);

    public String toString();

    public static class Operand {
        public final OperandType type;
        public final int value;

        public Operand(OperandType operandType, int n) {
            this.type = operandType;
            this.value = n;
        }

        public Expression asExpression(Registers registers, int n) {
            switch (this.type.ordinal()) {
                case 0: {
                    return registers.getExpression(this.value, n);
                }
                case 1: {
                    return registers.getKExpression(this.value, n);
                }
                case 2: {
                    return registers.getFunction().getConstantExpression(this.value);
                }
                case 3: {
                    return ConstantExpression.createInteger(this.value);
                }
                case 4: {
                    return ConstantExpression.createDouble(this.value);
                }
            }
            throw new IllegalStateException();
        }

        public boolean isRegister(Registers registers) {
            switch (this.type.ordinal()) {
                case 0: {
                    return true;
                }
                case 1: {
                    return !registers.isKConstant(this.value);
                }
                case 2: {
                    return false;
                }
                case 3: {
                    return false;
                }
                case 4: {
                    return false;
                }
            }
            throw new IllegalStateException();
        }

        public int getUpdated(Registers registers, int n) {
            switch (this.type.ordinal()) {
                case 0: {
                    return registers.getUpdated(this.value, n);
                }
                case 1: {
                    if (registers.isKConstant(this.value)) {
                        throw new IllegalStateException();
                    }
                    return registers.getUpdated(this.value, n);
                }
            }
            throw new IllegalStateException();
        }
    }

    public static enum OperandType {
        R,
        RK,
        K,
        I,
        F;

    }
}

