/*
 * Decompiled with CFR 0.152.
 */
package unluac.decompile.condition;

import unluac.decompile.Registers;
import unluac.decompile.condition.Condition;
import unluac.decompile.condition.NotCondition;
import unluac.decompile.expression.BinaryExpression;
import unluac.decompile.expression.Expression;

public class BinaryCondition
implements Condition {
    private final Operator op;
    private final int line;
    private final Condition.Operand left;
    private final Condition.Operand right;
    private final boolean inverted;

    private static String operator_to_string(Operator operator, boolean bl, boolean bl2) {
        switch (operator.ordinal()) {
            case 0: {
                return bl ? "~=" : "==";
            }
            case 1: {
                return bl2 ? ">" : "<";
            }
            case 2: {
                return bl2 ? ">=" : "<=";
            }
            case 3: {
                return bl2 ? "<" : ">";
            }
            case 4: {
                return bl2 ? "<=" : ">=";
            }
        }
        throw new IllegalStateException();
    }

    public BinaryCondition(Operator operator, int n, Condition.Operand operand, Condition.Operand operand2) {
        this(operator, n, operand, operand2, false);
    }

    private BinaryCondition(Operator operator, int n, Condition.Operand operand, Condition.Operand operand2, boolean bl) {
        this.op = operator;
        this.line = n;
        this.left = operand;
        this.right = operand2;
        this.inverted = bl;
    }

    @Override
    public Condition inverse() {
        if (this.op == Operator.EQ) {
            return new BinaryCondition(this.op, this.line, this.left, this.right, !this.inverted);
        }
        return new NotCondition(this);
    }

    @Override
    public boolean invertible() {
        return this.op == Operator.EQ;
    }

    @Override
    public int register() {
        return -1;
    }

    @Override
    public boolean isRegisterTest() {
        return false;
    }

    @Override
    public boolean isOrCondition() {
        return false;
    }

    @Override
    public boolean isSplitable() {
        return false;
    }

    @Override
    public Condition[] split() {
        throw new IllegalStateException();
    }

    @Override
    public Expression asExpression(Registers registers) {
        boolean bl = false;
        Expression expression = this.left.asExpression(registers, this.line);
        Expression expression2 = this.right.asExpression(registers, this.line);
        if (this.op != Operator.EQ || this.left.type == Condition.OperandType.K) {
            if (this.left.isRegister(registers) && this.right.isRegister(registers)) {
                bl = this.left.getUpdated(registers, this.line) > this.right.getUpdated(registers, this.line);
            } else {
                int n = expression2.getConstantIndex();
                int n2 = expression.getConstantIndex();
                if (n != -1 && n2 != -1) {
                    bl = this.left.type == Condition.OperandType.K && n == n2 ? true : n < n2;
                }
            }
        }
        String string = BinaryCondition.operator_to_string(this.op, this.inverted, bl);
        BinaryExpression binaryExpression = new BinaryExpression(string, !bl ? expression : expression2, !bl ? expression2 : expression, 3, 1);
        return binaryExpression;
    }

    @Override
    public String toString() {
        return String.valueOf(this.left) + " " + BinaryCondition.operator_to_string(this.op, this.inverted, false) + " " + String.valueOf(this.right);
    }

    public static enum Operator {
        EQ,
        LT,
        LE,
        GT,
        GE;

    }
}

