/*
 * Decompiled with CFR 0.152.
 */
package unluac.decompile.condition;

import unluac.decompile.Registers;
import unluac.decompile.condition.Condition;
import unluac.decompile.condition.NotCondition;
import unluac.decompile.condition.OrCondition;
import unluac.decompile.expression.BinaryExpression;
import unluac.decompile.expression.Expression;

public class AndCondition
implements Condition {
    private Condition left;
    private Condition right;

    public AndCondition(Condition condition, Condition condition2) {
        this.left = condition;
        this.right = condition2;
    }

    @Override
    public Condition inverse() {
        if (this.invertible()) {
            return new OrCondition(this.left.inverse(), this.right.inverse());
        }
        return new NotCondition(this);
    }

    @Override
    public boolean invertible() {
        return this.right.invertible();
    }

    @Override
    public int register() {
        return this.right.register();
    }

    @Override
    public boolean isRegisterTest() {
        return false;
    }

    @Override
    public boolean isOrCondition() {
        return false;
    }

    @Override
    public boolean isSplitable() {
        return true;
    }

    @Override
    public Condition[] split() {
        return new Condition[]{this.left, this.right};
    }

    @Override
    public Expression asExpression(Registers registers) {
        return new BinaryExpression("and", this.left.asExpression(registers), this.right.asExpression(registers), 2, 0);
    }

    @Override
    public String toString() {
        return String.valueOf(this.left) + " and " + String.valueOf(this.right);
    }
}

