/*
 * Decompiled with CFR 0.152.
 */
package unluac.decompile.block;

import unluac.decompile.CloseType;
import unluac.decompile.Decompiler;
import unluac.decompile.Output;
import unluac.decompile.Registers;
import unluac.decompile.Walker;
import unluac.decompile.block.ContainerBlock;
import unluac.decompile.condition.Condition;
import unluac.decompile.expression.Expression;
import unluac.decompile.statement.Statement;
import unluac.parse.LFunction;

public abstract class WhileBlock
extends ContainerBlock {
    protected Condition cond;
    private Expression condexpr;

    public WhileBlock(LFunction lFunction, Condition condition, int n, int n2, CloseType closeType, int n3) {
        super(lFunction, n, n2, closeType, n3, -1);
        this.cond = condition;
    }

    @Override
    public void resolve(Registers registers) {
        this.condexpr = this.cond.asExpression(registers);
    }

    @Override
    public void walk(Walker walker) {
        walker.visitStatement(this);
        this.condexpr.walk(walker);
        for (Statement statement : this.statements) {
            statement.walk(walker);
        }
    }

    @Override
    public boolean breakable() {
        return true;
    }

    @Override
    public boolean hasHeader() {
        return true;
    }

    @Override
    public int getLoopback() {
        throw new IllegalStateException();
    }

    @Override
    public void print(Decompiler decompiler, Output output) {
        output.print("while ");
        this.condexpr.print(decompiler, output);
        output.print(" do");
        output.println();
        output.indent();
        Statement.printSequence(decompiler, output, this.statements);
        output.dedent();
        output.print("end");
    }
}

