/*
 * Decompiled with CFR 0.152.
 */
package unluac.decompile.block;

import java.util.ArrayList;
import java.util.List;
import unluac.Version;
import unluac.decompile.CloseType;
import unluac.decompile.Decompiler;
import unluac.decompile.Output;
import unluac.decompile.Registers;
import unluac.decompile.Walker;
import unluac.decompile.block.ContainerBlock;
import unluac.decompile.expression.Expression;
import unluac.decompile.statement.Statement;
import unluac.decompile.target.Target;
import unluac.parse.LFunction;

public class TForBlock
extends ContainerBlock {
    protected final int internalRegisterFirst;
    protected final int internalRegisterLast;
    protected final int explicitRegisterFirst;
    protected final int explicitRegisterLast;
    protected final int internalScopeBegin;
    protected final int internalScopeEnd;
    protected final int explicitScopeBegin;
    protected final int explicitScopeEnd;
    protected final int innerScopeEnd;
    private Target[] targets;
    private Expression[] values;

    public static TForBlock make50(LFunction lFunction, int n, int n2, int n3, int n4, boolean bl) {
        int n5 = n2 - 3;
        if (bl) {
            --n5;
        }
        return new TForBlock(lFunction, n, n2, n3, n3 + 1, n3 + 2, n3 + 1 + n4, n - 1, n2 - 1, n - 1, n2 - 1, n5);
    }

    public static TForBlock make51(LFunction lFunction, int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        int n5 = n2 - 3;
        int n6 = n2 - 3;
        if (lFunction.header.version.closesemantics.get() == Version.CloseSemantics.JUMP) {
            if (bl) {
                --n6;
            }
        } else {
            if (bl) {
                --n5;
                --n6;
            }
            if (bl2) {
                --n6;
            }
        }
        return new TForBlock(lFunction, n, n2, n3, n3 + 2, n3 + 3, n3 + 2 + n4, n - 2, n2 - 1, n - 1, n5, n6);
    }

    public static TForBlock make54(LFunction lFunction, int n, int n2, int n3, int n4, boolean bl) {
        int n5 = n2 - 3;
        if (bl) {
            --n5;
        }
        return new TForBlock(lFunction, n, n2, n3, n3 + 3, n3 + 4, n3 + 3 + n4, n - 2, n2, n - 1, n2 - 3, n5);
    }

    public TForBlock(LFunction lFunction, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11) {
        super(lFunction, n, n2, CloseType.NONE, -1, -1);
        this.internalRegisterFirst = n3;
        this.internalRegisterLast = n4;
        this.explicitRegisterFirst = n5;
        this.explicitRegisterLast = n6;
        this.internalScopeBegin = n7;
        this.internalScopeEnd = n8;
        this.explicitScopeBegin = n9;
        this.explicitScopeEnd = n10;
        this.innerScopeEnd = n11;
    }

    public List<Target> getTargets(Registers registers) {
        ArrayList<Target> arrayList = new ArrayList<Target>(this.explicitRegisterLast - this.explicitRegisterFirst + 1);
        for (int i = this.explicitRegisterFirst; i <= this.explicitRegisterLast; ++i) {
            arrayList.add(registers.getTarget(i, this.begin - 1));
        }
        return arrayList;
    }

    public void handleVariableDeclarations(Registers registers) {
        int n;
        for (n = this.internalRegisterFirst; n <= this.internalRegisterLast; ++n) {
            registers.setInternalLoopVariable(n, this.internalScopeBegin, this.internalScopeEnd);
        }
        for (n = this.explicitRegisterFirst; n <= this.explicitRegisterLast; ++n) {
            registers.setExplicitLoopVariable(n, this.explicitScopeBegin, this.explicitScopeEnd);
        }
    }

    @Override
    public void resolve(Registers registers) {
        List<Target> list = this.getTargets(registers);
        ArrayList<Expression> arrayList = new ArrayList<Expression>(3);
        for (int i = this.internalRegisterFirst; i <= this.internalRegisterLast; ++i) {
            Expression expression = registers.getValue(i, this.begin - 1);
            arrayList.add(expression);
            if (expression.isMultiple()) break;
        }
        this.targets = list.toArray(new Target[list.size()]);
        this.values = arrayList.toArray(new Expression[arrayList.size()]);
    }

    @Override
    public void walk(Walker walker) {
        walker.visitStatement(this);
        for (Expression expression : this.values) {
            expression.walk(walker);
        }
        for (Statement statement : this.statements) {
            statement.walk(walker);
        }
    }

    @Override
    public int scopeEnd() {
        return this.innerScopeEnd;
    }

    @Override
    public boolean breakable() {
        return true;
    }

    @Override
    public boolean hasHeader() {
        return true;
    }

    @Override
    public boolean isUnprotected() {
        return false;
    }

    @Override
    public int getLoopback() {
        throw new IllegalStateException();
    }

    @Override
    public void print(Decompiler decompiler, Output output) {
        int n;
        output.print("for ");
        this.targets[0].print(decompiler, output, false);
        for (n = 1; n < this.targets.length; ++n) {
            output.print(", ");
            this.targets[n].print(decompiler, output, false);
        }
        output.print(" in ");
        this.values[0].print(decompiler, output);
        for (n = 1; n < this.values.length; ++n) {
            output.print(", ");
            this.values[n].print(decompiler, output);
        }
        output.print(" do");
        output.println();
        output.indent();
        Statement.printSequence(decompiler, output, this.statements);
        output.dedent();
        output.print("end");
    }
}

