/*
 * Decompiled with CFR 0.152.
 */
package unluac.decompile.block;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import unluac.decompile.ControlFlowHandler;
import unluac.decompile.Decompiler;
import unluac.decompile.Output;
import unluac.decompile.Registers;
import unluac.decompile.Walker;
import unluac.decompile.block.Block;
import unluac.decompile.condition.Condition;
import unluac.decompile.expression.Expression;
import unluac.decompile.operation.Operation;
import unluac.decompile.statement.Assignment;
import unluac.decompile.statement.Statement;
import unluac.parse.LFunction;

public class SetBlock
extends Block {
    public final int target;
    private Assignment assign;
    public final Condition cond;
    private Registers r;
    private boolean finalize = false;

    public SetBlock(LFunction lFunction, Condition condition, int n, int n2, int n3, int n4, Registers registers) {
        super(lFunction, n3, n4, 2);
        if (n3 == n4) {
            throw new IllegalStateException();
        }
        this.target = n;
        this.cond = condition;
        this.r = registers;
        if (n == -1) {
            throw new IllegalStateException();
        }
    }

    @Override
    public void walk(Walker walker) {
        throw new IllegalStateException();
    }

    @Override
    public void addStatement(Statement statement) {
        if (!this.finalize && statement instanceof Assignment) {
            this.assign = (Assignment)statement;
        }
    }

    @Override
    public boolean hasHeader() {
        return true;
    }

    @Override
    public boolean isUnprotected() {
        return false;
    }

    @Override
    public int getLoopback() {
        throw new IllegalStateException();
    }

    @Override
    public void print(Decompiler decompiler, Output output) {
        if (this.assign == null || this.assign.getFirstTarget() == null) {
            throw new IllegalStateException();
        }
        Assignment assignment = new Assignment(this.assign.getFirstTarget(), this.getValue(), this.assign.getFirstLine());
        assignment.print(decompiler, output);
    }

    @Override
    public boolean breakable() {
        return false;
    }

    @Override
    public boolean isContainer() {
        return true;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    public void useAssignment(Assignment assignment) {
        this.assign = assignment;
    }

    public Expression getValue() {
        return this.cond.asExpression(this.r);
    }

    @Override
    public Operation process(Decompiler decompiler) {
        if (ControlFlowHandler.verbose) {
            System.out.print("set expression: ");
            this.cond.asExpression(this.r).print(decompiler, new Output());
            System.out.println();
        }
        if (this.assign != null) {
            this.assign.replaceValue(this.target, this.getValue());
            return new Operation(this.end - 1){

                @Override
                public List<Statement> process(Registers registers, Block block) {
                    return Arrays.asList(SetBlock.this.assign);
                }
            };
        }
        return new Operation(this.end - 1){

            @Override
            public List<Statement> process(Registers registers, Block block) {
                if (registers.isLocal(SetBlock.this.target, SetBlock.this.end - 1)) {
                    return Arrays.asList(new Assignment(registers.getTarget(SetBlock.this.target, SetBlock.this.end - 1), SetBlock.this.cond.asExpression(registers), SetBlock.this.end - 1));
                }
                registers.setValue(SetBlock.this.target, SetBlock.this.end - 1, SetBlock.this.cond.asExpression(registers));
                return Collections.emptyList();
            }
        };
    }
}

