/*
 * Decompiled with CFR 0.152.
 */
package unluac.decompile.block;

import unluac.decompile.CloseType;
import unluac.decompile.Decompiler;
import unluac.decompile.Output;
import unluac.decompile.Registers;
import unluac.decompile.Walker;
import unluac.decompile.block.ContainerBlock;
import unluac.decompile.condition.Condition;
import unluac.decompile.expression.Expression;
import unluac.decompile.statement.Statement;
import unluac.parse.LFunction;

public class RepeatBlock
extends ContainerBlock {
    private final Condition cond;
    private final boolean extendedRepeatScope;
    private final int scopeEnd;
    private Expression condexpr;

    public RepeatBlock(LFunction lFunction, Condition condition, int n, int n2, CloseType closeType, int n3, boolean bl, int n4) {
        super(lFunction, n, n2, closeType, n3, 0);
        this.cond = condition;
        this.extendedRepeatScope = bl;
        this.scopeEnd = n4;
    }

    @Override
    public void resolve(Registers registers) {
        this.condexpr = this.cond.asExpression(registers);
    }

    @Override
    public void walk(Walker walker) {
        walker.visitStatement(this);
        for (Statement statement : this.statements) {
            statement.walk(walker);
        }
        this.condexpr.walk(walker);
    }

    @Override
    public int scopeEnd() {
        if (this.extendedRepeatScope) {
            return this.usingClose && this.closeType != CloseType.NONE ? this.closeLine - 1 : this.scopeEnd;
        }
        return this.usingClose && this.closeType != CloseType.NONE ? this.closeLine : super.scopeEnd();
    }

    @Override
    public boolean breakable() {
        return true;
    }

    @Override
    public boolean hasHeader() {
        return false;
    }

    @Override
    public boolean isUnprotected() {
        return false;
    }

    @Override
    public int getLoopback() {
        throw new IllegalStateException();
    }

    @Override
    public void print(Decompiler decompiler, Output output) {
        output.print("repeat");
        output.println();
        output.indent();
        Statement.printSequence(decompiler, output, this.statements);
        output.dedent();
        output.print("until ");
        this.condexpr.print(decompiler, output);
    }
}

