/*
 * Decompiled with CFR 0.152.
 */
package unluac.decompile.block;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import unluac.decompile.CloseType;
import unluac.decompile.Decompiler;
import unluac.decompile.Output;
import unluac.decompile.Registers;
import unluac.decompile.Walker;
import unluac.decompile.block.Block;
import unluac.decompile.block.ContainerBlock;
import unluac.decompile.condition.AndCondition;
import unluac.decompile.condition.Condition;
import unluac.decompile.condition.FinalSetCondition;
import unluac.decompile.condition.OrCondition;
import unluac.decompile.expression.Expression;
import unluac.decompile.operation.Operation;
import unluac.decompile.statement.Assignment;
import unluac.decompile.statement.Statement;
import unluac.parse.LFunction;

public class IfThenEndBlock
extends ContainerBlock {
    private final Condition cond;
    private final boolean redirected;
    private final Registers r;
    private Expression condexpr;

    public IfThenEndBlock(LFunction lFunction, Registers registers, Condition condition, int n, int n2) {
        this(lFunction, registers, condition, n, n2, CloseType.NONE, -1, false);
    }

    public IfThenEndBlock(LFunction lFunction, Registers registers, Condition condition, int n, int n2, CloseType closeType, int n3, boolean bl) {
        super(lFunction, n == n2 ? n - 1 : n, n2, closeType, n3, -1);
        this.r = registers;
        this.cond = condition;
        this.redirected = bl;
    }

    @Override
    public int scopeEnd() {
        return this.usingClose && this.closeType == CloseType.CLOSE ? this.closeLine - 1 : super.scopeEnd();
    }

    @Override
    public void resolve(Registers registers) {
        this.condexpr = this.cond.asExpression(registers);
    }

    @Override
    public void walk(Walker walker) {
        walker.visitStatement(this);
        this.condexpr.walk(walker);
        for (Statement statement : this.statements) {
            statement.walk(walker);
        }
    }

    @Override
    public boolean breakable() {
        return false;
    }

    @Override
    public boolean hasHeader() {
        return false;
    }

    @Override
    public boolean isUnprotected() {
        return false;
    }

    @Override
    public int getLoopback() {
        throw new IllegalStateException();
    }

    @Override
    public Operation process(Decompiler decompiler) {
        final int n = this.cond.register();
        if (!(this.scopeUsed || this.redirected || n < 0 || this.r.getUpdated(n, this.end - 1) < this.begin || decompiler.getNoDebug())) {
            int n2;
            Statement statement;
            Assignment assignment = null;
            if (this.statements.size() == 1 && (statement = (Statement)this.statements.get(0)) instanceof Assignment && (assignment = (Assignment)statement).getArity() > 1 && (n2 = assignment.getFirstLine()) >= this.begin && n2 < this.end) {
                assignment = null;
            }
            boolean bl = false;
            if (assignment != null) {
                if (assignment.hasExcess()) {
                    bl = assignment.getLastRegister() == n;
                } else {
                    boolean bl2 = bl = assignment.getLastTarget().isLocal() && assignment.getLastTarget().getIndex() == n;
                }
            }
            if (assignment != null && (this.cond.isRegisterTest() || this.cond.isOrCondition() || assignment.isDeclaration()) && bl || this.statements.isEmpty()) {
                Assignment assignment2;
                FinalSetCondition finalSetCondition = new FinalSetCondition(this.end - 1, n);
                finalSetCondition.type = FinalSetCondition.Type.VALUE;
                Condition condition = this.cond.invertible() ? new OrCondition(this.cond.inverse(), finalSetCondition) : new AndCondition(this.cond, finalSetCondition);
                if (assignment != null) {
                    assignment2 = assignment;
                    assignment2.replaceLastValue(condition.asExpression(this.r));
                } else {
                    assignment2 = null;
                }
                final Condition condition2 = condition;
                return new Operation(this.end - 1){

                    @Override
                    public List<Statement> process(Registers registers, Block block) {
                        if (assignment2 == null) {
                            registers.setValue(n, IfThenEndBlock.this.end - 1, condition2.asExpression(registers));
                            return Collections.emptyList();
                        }
                        return Arrays.asList(assignment2);
                    }
                };
            }
        }
        return super.process(decompiler);
    }

    @Override
    public void print(Decompiler decompiler, Output output) {
        output.print("if ");
        this.condexpr.print(decompiler, output);
        output.print(" then");
        output.println();
        output.indent();
        Statement.printSequence(decompiler, output, this.statements);
        output.dedent();
        output.print("end");
    }
}

