/*
 * Decompiled with CFR 0.152.
 */
package unluac.decompile.block;

import unluac.decompile.CloseType;
import unluac.decompile.Decompiler;
import unluac.decompile.Output;
import unluac.decompile.Registers;
import unluac.decompile.Walker;
import unluac.decompile.block.Block;
import unluac.decompile.block.ContainerBlock;
import unluac.decompile.block.ElseEndBlock;
import unluac.decompile.condition.Condition;
import unluac.decompile.expression.Expression;
import unluac.decompile.statement.Statement;
import unluac.parse.LFunction;

public class IfThenElseBlock
extends ContainerBlock {
    private final Condition cond;
    private final int elseTarget;
    public ElseEndBlock partner;
    private Expression condexpr;

    public IfThenElseBlock(LFunction lFunction, Condition condition, int n, int n2, int n3, CloseType closeType, int n4) {
        super(lFunction, n, n2, closeType, n4, -1);
        this.cond = condition;
        this.elseTarget = n3;
    }

    @Override
    public void resolve(Registers registers) {
        this.condexpr = this.cond.asExpression(registers);
    }

    @Override
    public void walk(Walker walker) {
        walker.visitStatement(this);
        this.condexpr.walk(walker);
        for (Statement statement : this.statements) {
            statement.walk(walker);
        }
    }

    @Override
    public boolean suppressNewline() {
        return true;
    }

    @Override
    public int compareTo(Block block) {
        if (block == this.partner) {
            return -1;
        }
        return super.compareTo(block);
    }

    @Override
    public boolean breakable() {
        return false;
    }

    @Override
    public int scopeEnd() {
        return this.usingClose && this.closeType == CloseType.CLOSE ? this.closeLine - 1 : this.end - 2;
    }

    @Override
    public boolean hasHeader() {
        return true;
    }

    @Override
    public boolean isUnprotected() {
        return true;
    }

    @Override
    public int getUnprotectedLine() {
        return this.end - 1;
    }

    @Override
    public int getUnprotectedTarget() {
        return this.elseTarget;
    }

    @Override
    public int getLoopback() {
        throw new IllegalStateException();
    }

    @Override
    public void print(Decompiler decompiler, Output output) {
        output.print("if ");
        this.condexpr.print(decompiler, output);
        output.print(" then");
        output.println();
        output.indent();
        Statement.printSequence(decompiler, output, this.statements);
        output.dedent();
        if (this.end == this.elseTarget) {
            output.println("else");
            output.println("end");
        }
    }
}

