/*
 * Decompiled with CFR 0.152.
 */
package unluac.decompile.block;

import unluac.decompile.CloseType;
import unluac.decompile.Decompiler;
import unluac.decompile.Output;
import unluac.decompile.Registers;
import unluac.decompile.Walker;
import unluac.decompile.block.ContainerBlock;
import unluac.decompile.expression.Expression;
import unluac.decompile.statement.Statement;
import unluac.decompile.target.Target;
import unluac.parse.LFunction;

public abstract class ForBlock
extends ContainerBlock {
    protected final int register;
    protected final boolean forvarPreClose;
    protected Target target;
    protected Expression start;
    protected Expression stop;
    protected Expression step;

    public ForBlock(LFunction lFunction, int n, int n2, int n3, CloseType closeType, int n4, boolean bl) {
        super(lFunction, n, n2, closeType, n4, -1);
        this.register = n3;
        this.forvarPreClose = bl;
    }

    public abstract void handleVariableDeclarations(Registers var1);

    @Override
    public void walk(Walker walker) {
        walker.visitStatement(this);
        this.start.walk(walker);
        this.stop.walk(walker);
        this.step.walk(walker);
        for (Statement statement : this.statements) {
            statement.walk(walker);
        }
    }

    @Override
    public int scopeEnd() {
        int n = this.end - 2;
        if (this.forvarPreClose) {
            --n;
        }
        if (this.usingClose && this.closeType == CloseType.CLOSE) {
            --n;
        }
        return n;
    }

    @Override
    public boolean breakable() {
        return true;
    }

    @Override
    public boolean hasHeader() {
        return true;
    }

    @Override
    public boolean isUnprotected() {
        return false;
    }

    @Override
    public int getLoopback() {
        throw new IllegalStateException();
    }

    @Override
    public void print(Decompiler decompiler, Output output) {
        output.print("for ");
        this.target.print(decompiler, output, false);
        output.print(" = ");
        this.start.print(decompiler, output);
        output.print(", ");
        this.stop.print(decompiler, output);
        if (!this.step.isInteger() || this.step.asInteger() != 1) {
            output.print(", ");
            this.step.print(decompiler, output);
        }
        output.print(" do");
        output.println();
        output.indent();
        Statement.printSequence(decompiler, output, this.statements);
        output.dedent();
        output.print("end");
    }
}

